"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_TROUBLESHOOTING({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M23,11H21.94928A10.017,10.017,0,0,0,13,2.05066V0H11V2.05066A10.01652,10.01652,0,0,0,2.05066,11H0v2H2.05066A10.017,10.017,0,0,0,11,21.94928V24h2V21.94928A10.0174,10.0174,0,0,0,21.94928,13H24V11Zm-9.2774,0A1.99536,1.99536,0,0,0,13,10.2774v-2.396A4.24808,4.24808,0,0,1,16.11853,11Zm2.396,2A4.24777,4.24777,0,0,1,13,16.11859v-2.396A1.99489,1.99489,0,0,0,13.7226,13ZM11,4.06946V6.3429A5.75748,5.75748,0,0,0,6.3429,11H4.06946A8.00705,8.00705,0,0,1,11,4.06946ZM10.2774,11H7.88147A4.24858,4.24858,0,0,1,11,7.88147V10.2774A1.99536,1.99536,0,0,0,10.2774,11ZM11,13.7226v2.39593A4.24808,4.24808,0,0,1,7.88141,13h2.396A1.99489,1.99489,0,0,0,11,13.7226ZM4.06946,13H6.3429A5.757,5.757,0,0,0,11,17.6571v2.27344A8.00705,8.00705,0,0,1,4.06946,13ZM13,19.93054V17.6571A5.75661,5.75661,0,0,0,17.6571,13h2.27344A8.00705,8.00705,0,0,1,13,19.93054ZM17.6571,11A5.757,5.757,0,0,0,13,6.3429V4.06946A8.00705,8.00705,0,0,1,19.93054,11Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M23,11H21.94928A10.017,10.017,0,0,0,13,2.05066V0H11V2.05066A10.01652,10.01652,0,0,0,2.05066,11H0v2H2.05066A10.017,10.017,0,0,0,11,21.94928V24h2V21.94928A10.0174,10.0174,0,0,0,21.94928,13H24V11Zm-9.2774,0A1.99536,1.99536,0,0,0,13,10.2774v-2.396A4.24808,4.24808,0,0,1,16.11853,11Zm2.396,2A4.24777,4.24777,0,0,1,13,16.11859v-2.396A1.99489,1.99489,0,0,0,13.7226,13ZM11,4.06946V6.3429A5.75748,5.75748,0,0,0,6.3429,11H4.06946A8.00705,8.00705,0,0,1,11,4.06946ZM10.2774,11H7.88147A4.24858,4.24858,0,0,1,11,7.88147V10.2774A1.99536,1.99536,0,0,0,10.2774,11ZM11,13.7226v2.39593A4.24808,4.24808,0,0,1,7.88141,13h2.396A1.99489,1.99489,0,0,0,11,13.7226ZM4.06946,13H6.3429A5.757,5.757,0,0,0,11,17.6571v2.27344A8.00705,8.00705,0,0,1,4.06946,13ZM13,19.93054V17.6571A5.75661,5.75661,0,0,0,17.6571,13h2.27344A8.00705,8.00705,0,0,1,13,19.93054ZM17.6571,11A5.757,5.757,0,0,0,13,6.3429V4.06946A8.00705,8.00705,0,0,1,19.93054,11Z" }))));
}
;
exports.default = EOS_TROUBLESHOOTING;
