"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_TEST_TUBE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, id: "Layer_1", "data-name": "Layer 1", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "13", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "11.5", cy: "7.5", r: "0.5" }),
                React.createElement("circle", { cx: "12.5", cy: "5.5", r: "0.5" }),
                React.createElement("path", { d: "M5,0V2H7V19a5,5,0,0,0,10,0V2h2V0ZM15,2V15H12a1,1,0,0,0-2,0H9V2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, id: "Layer_1", "data-name": "Layer 1", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "13", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "11.5", cy: "7.5", r: "0.5" }),
                React.createElement("circle", { cx: "12.5", cy: "5.5", r: "0.5" }),
                React.createElement("path", { d: "M5,0V2H7V19a5,5,0,0,0,10,0V2h2V0ZM15,2V15H12a1,1,0,0,0-2,0H9V2Z" }))));
}
;
exports.default = EOS_TEST_TUBE;
