"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_SYSTEM_GROUP({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M17,1H3A2,2,0,0,0,1,3H1v9H3V3H17Z" }),
                React.createElement("path", { d: "M21,5H7A2,2,0,0,0,5,7V17a2,2,0,0,0,2,2h5.53v1.53H11V22h6V20.52H15.48V19H21a2,2,0,0,0,2-2V7A2,2,0,0,0,21,5Zm0,12H7V7H21Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M17,1H3A2,2,0,0,0,1,3H1v9H3V3H17Z" }),
                React.createElement("path", { d: "M21,5H7A2,2,0,0,0,5,7V17a2,2,0,0,0,2,2h5.53v1.53H11V22h6V20.52H15.48V19H21a2,2,0,0,0,2-2V7A2,2,0,0,0,21,5Zm0,12H7V7H21Z" }))));
}
;
exports.default = EOS_SYSTEM_GROUP;
