"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_SYMLINK({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M14,2H6A2,2,0,0,0,4,4V20a2,2,0,0,0,2,2H18a2,2,0,0,0,2-2V8ZM13,19.47V17.28c-2.78,0-4.61.85-6,2.72.56-2.67,2.11-5.33,6-5.87V12l4,3.73ZM13,9V3.5L18.51,9Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M13,12l4,3.5L13,19V17a6.95649,6.95649,0,0,0-6,3c.56-2.67,2.11-5.46,6-6Z" }),
                React.createElement("path", { d: "M13,4l5,5H13Z" }),
                React.createElement("path", { d: "M14.68,0H4A2.00587,2.00587,0,0,0,2,2V22a2.00591,2.00591,0,0,0,2,2H20a2.00591,2.00591,0,0,0,2-2V7.15ZM20,22H4V2h9.83L20,8Z" }))));
}
;
exports.default = EOS_SYMLINK;
