"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_STATEFUL_SET({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M6.00039,17.99764V5H4V17.99764H4A2.00138,2.00138,0,0,0,6.00039,20H19V17.99764H6.00039Z" }),
                React.createElement("path", { d: "M2.00979,21.999V9H.01V21.999h0A2.00041,2.00041,0,0,0,2.00979,24H15.01V21.999H2.00979Z" }),
                React.createElement("path", { d: "M15.50006,8.76288l-.00076,0-.00076,0a9.17251,9.17251,0,0,1-2.08484-.22942,6.19694,6.19694,0,0,1-1.66516-.63343v3.34527h.00195c0,.30759.3652.68475,1.0165.985a6.64475,6.64475,0,0,0,2.73307.52375,6.64452,6.64452,0,0,0,2.733-.52375c.65128-.30029,1.01647-.67745,1.01647-.985h.002V7.90009a6.19714,6.19714,0,0,1-1.66517.63343,9.17242,9.17242,0,0,1-2.08483.22942l-.00074,0Z" }),
                React.createElement("path", { d: "M15.50763,4.24615v.00013l-.00381-.00014-.00376-.00023-.00379.00023-.00384.00014V4.24615a6.64172,6.64172,0,0,0-2.729.52438c-.65031.30007-1.01494.67677-1.01494.98411,0,.3071.36463.68367,1.01494.98368a6.64265,6.64265,0,0,0,2.729.52431V7.26251l.00384.00014.00379.00023.00376-.00023.00381-.00014v.00012a6.64265,6.64265,0,0,0,2.72895-.52431c.65031-.3,1.01495-.67658,1.01495-.98368,0-.30734-.36464-.684-1.01495-.98411A6.64172,6.64172,0,0,0,15.50763,4.24615Z" }),
                React.createElement("path", { d: "M20.99982,1H10.00018A2.00017,2.00017,0,0,0,8,3.00012v10.9997A2.00018,2.00018,0,0,0,10.00018,16H20.99982A2.00018,2.00018,0,0,0,23,13.99982V3.00012A2.00017,2.00017,0,0,0,20.99982,1Zm-.24829,4.79956v5.4458h-.002a2.56878,2.56878,0,0,1-1.50011,2.14592,7.65763,7.65763,0,0,1-3.74183.86244v.00006l-.00357.00019-.00357.00018h-.00092L15.496,14.254l-.00357-.00019v-.00006a7.65766,7.65766,0,0,1-3.74183-.86244,2.5688,2.5688,0,0,1-1.50011-2.14592h-.00195V5.75464A2.57053,2.57053,0,0,1,11.7511,3.607a7.66354,7.66354,0,0,1,3.74744-.86114l.00076,0,.00076,0,.00073,0,.00074,0A7.66352,7.66352,0,0,1,19.249,3.607a2.57054,2.57054,0,0,1,1.50257,2.14765v.04492Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M8,16V4H6V16H6v-.00236A2.15115,2.15115,0,0,0,8.00039,18H21V16Z" }),
                React.createElement("path", { d: "M4,20V8H2V20H2a2.14856,2.14856,0,0,0,2,2H17V20Z" }),
                React.createElement("path", { d: "M11.00205,10.86266a2.6786,2.6786,0,0,0,1.5711,2.23762A8.0491,8.0491,0,0,0,16.492,14v-.00038l.00377.00019L16.49952,14h.001l.00377-.00019.00371-.00019v-.00007a8.04885,8.04885,0,0,0,3.91889-.89927,2.6786,2.6786,0,0,0,1.5711-2.23762H22V5.13734a2.6804,2.6804,0,0,0-1.57367-2.2394A8.05484,8.05484,0,0,0,16.50157,2H16.5008L16.5,2.00006,16.49926,2h-.00083a8.05484,8.05484,0,0,0-3.92476.89794A2.6804,2.6804,0,0,0,11,5.13734v5.72532h.00205ZM13.634,4.11116A6.983,6.983,0,0,1,16.492,3.56441v.00012l.004-.00012.004-.00026.004.00026.004.00012V3.56441a6.98249,6.98249,0,0,1,2.85808.54675c.6811.31294,1.063.70568,1.063,1.02618,0,.32019-.38188.71287-1.063,1.02567a6.98247,6.98247,0,0,1-2.85808.54676V6.70964l-.004.00013L16.5,6.71l-.004-.00025-.004-.00013v.00013A6.98294,6.98294,0,0,1,13.634,6.163c-.6811-.3128-1.063-.70548-1.063-1.02567C12.571,4.81684,12.95286,4.4241,13.634,4.11116ZM12.571,9.11852V7.37445a6.50791,6.50791,0,0,0,1.744.66049,9.64735,9.64735,0,0,0,2.18349.23923l.00083-.00006h.00154l.00077.00006a9.64689,9.64689,0,0,0,2.18349-.23923,6.507,6.507,0,0,0,1.744-.66049v3.48821H20.427c0,.3207-.38245.714-1.06458,1.02713A6.9851,6.9851,0,0,1,16.5,12.43591a6.98588,6.98588,0,0,1-2.86242-.54612c-.68207-.31312-1.06458-.70643-1.06458-1.02713h-.002Z" }))));
}
;
exports.default = EOS_STATEFUL_SET;
