"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_SPINNER({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "11", y: "2", width: "2", height: "5" }),
                React.createElement("rect", { x: "11", y: "17", width: "2", height: "5" }),
                React.createElement("rect", { x: "18.5", y: "9.5", width: "2", height: "5", transform: "translate(31.5 -7.5) rotate(90)" }),
                React.createElement("rect", { x: "3.5", y: "9.5", width: "2", height: "5", transform: "translate(16.5 7.5) rotate(90)" }),
                React.createElement("rect", { x: "16.3033", y: "4.1967", width: "2", height: "5", transform: "translate(9.8033 -10.27386) rotate(45)" }),
                React.createElement("rect", { x: "5.6967", y: "14.8033", width: "2", height: "5", transform: "translate(14.1967 0.33274) rotate(45)" }),
                React.createElement("rect", { x: "16.3033", y: "14.8033", width: "2", height: "5", transform: "translate(41.77386 17.3033) rotate(135)" }),
                React.createElement("rect", { x: "5.6967", y: "4.1967", width: "2", height: "5", transform: "translate(16.16726 6.6967) rotate(135)" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "11", y: "2", width: "2", height: "5" }),
                React.createElement("rect", { x: "11", y: "17", width: "2", height: "5" }),
                React.createElement("rect", { x: "18.5", y: "9.5", width: "2", height: "5", transform: "translate(31.5 -7.5) rotate(90)" }),
                React.createElement("rect", { x: "3.5", y: "9.5", width: "2", height: "5", transform: "translate(16.5 7.5) rotate(90)" }),
                React.createElement("rect", { x: "16.3033", y: "4.1967", width: "2", height: "5", transform: "translate(9.8033 -10.27386) rotate(45)" }),
                React.createElement("rect", { x: "5.6967", y: "14.8033", width: "2", height: "5", transform: "translate(14.1967 0.33274) rotate(45)" }),
                React.createElement("rect", { x: "16.3033", y: "14.8033", width: "2", height: "5", transform: "translate(41.77386 17.3033) rotate(135)" }),
                React.createElement("rect", { x: "5.6967", y: "4.1967", width: "2", height: "5", transform: "translate(16.16726 6.6967) rotate(135)" }))));
}
;
exports.default = EOS_SPINNER;
