"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_SERVICE_INSTANCE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "3 21 4.01 21 5.03 21 5.03 18 5.03 15 4.01 15 3 15 3 18 3 21" }),
                React.createElement("path", { d: "M12.45,22l-2.93-.64-2.93-.64A.76.76,0,0,1,6,20v-4a.71.71,0,0,1,.17-.47.75.75,0,0,1,.43-.27l4.78-.59L16.17,14l.15.55.15.55a1,1,0,0,1-.56.9l-2,.5-2,.5,1.62.65,1.62.65,2.28-.64L19.65,17a.73.73,0,0,1,.58.07.75.75,0,0,1,.36.47l.19.76.2.77a.74.74,0,0,1-.54.9l-3.63,1-3.63,1a1.49,1.49,0,0,1-.36.05A1.55,1.55,0,0,1,12.45,22Z" }),
                React.createElement("polygon", { points: "18.02 8.5 14.52 6.25 11.02 4 11.02 8.5 11.02 13 14.52 10.75 18.02 8.5" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20.97723,19.08972l-.38794-1.53155a.74677.74677,0,0,0-.35614-.46643.76426.76426,0,0,0-.58728-.07148L15.0943,18.304,12,17l3.91461-1.00336a1.87961,1.87961,0,0,0,.55878-.89239L16.16559,14,8,15H3v6H8l4.45477.96436a3.19359,3.19359,0,0,0,.7276-.01709l7.259-1.95429a.75456.75456,0,0,0,.45453-.34375A.73758.73758,0,0,0,20.97723,19.08972ZM6,20H4V16H6v4Zm6.92236.98163A.55692.55692,0,0,1,12.78357,21a.53837.53837,0,0,1-.11456-.01239L8,19.96332v-3.9444l7.32886-.90765L10,17l4.72125,2.23181.31635.1272.32812-.09253,4.31635-1.21741.26385,1.04169Z" }),
                React.createElement("path", { d: "M9,2V13l8.18-5.5Zm2,3.76L13.6,7.5,11,9.25Z" }))));
}
;
exports.default = EOS_SERVICE_INSTANCE;
