"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_SECRET({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M18,9.5A2.49248,2.49248,0,0,0,13.51129,8H10.48871a2.43563,2.43563,0,1,0,.46087,1h2.10084A2.5,2.5,0,1,0,18,9.5Z" }),
                React.createElement("path", { d: "M20,5H17V2a2,2,0,0,0-2-2H9A2,2,0,0,0,7,2V5H4V6H20Z" }),
                React.createElement("path", { d: "M5,17H4a4,4,0,0,0-4,4v3H8L7,23l2-2Z" }),
                React.createElement("path", { d: "M20,17H19l-4,4,2,2-1,1h8V21A4,4,0,0,0,20,17Z" }),
                React.createElement("rect", { x: "11", y: "20", width: "2", height: "4" }),
                React.createElement("polygon", { points: "12 18 11 20 13 20 12 18" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M4.17158,19l2,2-1,1H2V21a2.00227,2.00227,0,0,1,2-2h.17158M5,17H4a4,4,0,0,0-4,4v3H8L7,23l2-2L5,17Z" }),
                React.createElement("path", { d: "M19.82842,19H20a2.00227,2.00227,0,0,1,2,2v1H18.82842l-1-1,2-2M19,17l-4,4,2,2-1,1h8V21a4,4,0,0,0-4-4Z" }),
                React.createElement("polygon", { points: "12 18 11 20 11 24 13 24 13 20 12 18" }),
                React.createElement("path", { d: "M17,5V2a2,2,0,0,0-2-2H9A2,2,0,0,0,7,2V5H4V6H20V5ZM15,4H9V2h6Z" }),
                React.createElement("path", { d: "M15.5,7a2.488,2.488,0,0,0-1.98871,1H10.48871a2.43563,2.43563,0,1,0,.46087,1h2.10084A2.5,2.5,0,1,0,15.5,7Zm-7,3.5a1,1,0,1,1,1-1A1,1,0,0,1,8.5,10.5Zm7,0a1,1,0,1,1,1-1A1,1,0,0,1,15.5,10.5Z" }))));
}
;
exports.default = EOS_SECRET;
