"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_ROTATE_90_DEGREES_CCW({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M7.34 6.41L.86 12.9l6.49 6.48 6.49-6.48-6.5-6.49zM3.69 12.9l3.66-3.66L11 12.9l-3.66 3.66-3.65-3.66zm15.67-6.26C17.61 4.88 15.3 4 13 4V.76L8.76 5 13 9.24V6c1.79 0 3.58.68 4.95 2.05 2.73 2.73 2.73 7.17 0 9.9C16.58 19.32 14.79 20 13 20c-.97 0-1.94-.21-2.84-.61l-1.49 1.49C10.02 21.62 11.51 22 13 22c2.3 0 4.61-.88 6.36-2.64 3.52-3.51 3.52-9.21 0-12.72z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M7.34 6.41L.86 12.9l6.49 6.48 6.49-6.48-6.5-6.49zM3.69 12.9l3.66-3.66L11 12.9l-3.66 3.66-3.65-3.66zm15.67-6.26C17.61 4.88 15.3 4 13 4V.76L8.76 5 13 9.24V6c1.79 0 3.58.68 4.95 2.05 2.73 2.73 2.73 7.17 0 9.9C16.58 19.32 14.79 20 13 20c-.97 0-1.94-.21-2.84-.61l-1.49 1.49C10.02 21.62 11.51 22 13 22c2.3 0 4.61-.88 6.36-2.64 3.52-3.51 3.52-9.21 0-12.72z" }))));
}
;
exports.default = EOS_ROTATE_90_DEGREES_CCW;
