"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_PRODUCT_SUBSCRIPTIONS({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,8H4V6H20ZM18,2H6V4H18Zm4,10v8a2,2,0,0,1-2,2H4a2.00591,2.00591,0,0,1-2-2V12a2.00587,2.00587,0,0,1,2-2H20A2.00587,2.00587,0,0,1,22,12Zm-8.07263,5.042L16.25,15.05573l-3.05884-.25593L12,12l-1.19116,2.7998L7.75,15.05573,10.07263,17.042,9.37335,20,12,18.4278,14.62665,20Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "12.841 15.1 12 13 11.159 15.1 9 15.292 10.64 16.781 10.146 19 12 17.821 13.854 19 13.36 16.781 15 15.292 12.841 15.1" }),
                React.createElement("rect", { x: "6", y: "2", width: "12", height: "2" }),
                React.createElement("rect", { x: "4", y: "6", width: "16", height: "2" }),
                React.createElement("path", { d: "M20,12v8H4V12H20m0-2H4a2,2,0,0,0-2,2v8a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z" }))));
}
;
exports.default = EOS_PRODUCT_SUBSCRIPTIONS;
