"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_PRODUCT_CLASSES({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M7,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H7a1,1,0,0,0,1-1V3A1,1,0,0,0,7,2ZM5,21a2,2,0,1,1,2-2A2,2,0,0,1,5,21Zm2-9H3V3H7Z" }),
                React.createElement("circle", { cx: "5.01", cy: "19.01", r: "1" }),
                React.createElement("polygon", { points: "10.01 2 10.01 9 10.01 11.01 15.01 11.01 15.01 9 15.01 2 10.01 2" }),
                React.createElement("polygon", { points: "17 2 17 9 17 11.01 22 11.01 22 9 22 2 17 2" }),
                React.createElement("polygon", { points: "10.01 13 10.01 20 10.01 20.01 10.01 22 15.01 22 15.01 20.01 15.01 20 15.01 13 10.01 13" }),
                React.createElement("polygon", { points: "17 13 17 20 17 22 22 22 22 20 22 13 17 13" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "5", cy: "19", r: "1" }),
                React.createElement("rect", { x: "4", y: "4", width: "2", height: "9" }),
                React.createElement("path", { d: "M7,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H7a1,1,0,0,0,1-1V3A1,1,0,0,0,7,2ZM7,21H3V3H7Z" }),
                React.createElement("path", { d: "M14,3v7H11V3h3m1-1H10v9h5V2Z" }),
                React.createElement("path", { d: "M21,3v7H18V3h3m1-1H17v9h5V2Z" }),
                React.createElement("path", { d: "M14,14v7H11V14h3m1-1H10v9h5V13Z" }),
                React.createElement("path", { d: "M21,14v7H18V14h3m1-1H17v9h5V13Z" }))));
}
;
exports.default = EOS_PRODUCT_CLASSES;
