"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_PRIMITIVE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "12.00002", cy: "12", r: "2.197" }),
                React.createElement("path", { d: "M21.63441,6.43671c-.70909-1.22723-2.41155-1.73142-4.79628-1.42354-.30258.03942-.61354.09379-.92927.15769C15.00856,2.619,13.6066,1,12,1,10.39089,1,8.98713,2.62441,8.087,5.1834c-2.7384-.54268-4.90657-.15669-5.72186,1.25331C1.55256,7.84376,2.2947,9.90626,4.12193,12,2.2947,14.09374,1.55256,16.15624,2.3651,17.56329c.58143,1.00732,1.85,1.49542,3.52453,1.49542a11.47535,11.47535,0,0,0,2.197-.24305C8.98673,21.37518,10.39069,23,12,23c1.60658,0,3.00854-1.619,3.90884-4.17086.31573.0639.62669.11827.92927.15769a10.18235,10.18235,0,0,0,1.297.088c1.70461,0,2.92647-.52028,3.49932-1.51151.81254-1.407.07053-3.46955-1.75643-5.56329C21.70494,9.90626,22.447,7.84376,21.63441,6.43671ZM16.9851,6.13956a9.0809,9.0809,0,0,1,1.15965-.08046c1.26048,0,2.14979.32826,2.507.94617.50426.87335-.06645,2.44138-1.55187,4.16777a20.50554,20.50554,0,0,0-2.30139-1.95281,19.9752,19.9752,0,0,0-.5471-2.93612C16.49539,6.23744,16.7503,6.17013,16.9851,6.13956Zm-3.07236,9.17417c-.64647.37332-1.28408.70346-1.90695.9935-.63936-.29755-1.2812-.62534-1.919-.9935-.64888-.37459-1.25525-.76326-1.81959-1.15917-.06229-.6861-.09688-1.405-.09688-2.15456s.03459-1.46846.09688-2.15456c.56434-.39591,1.17071-.78458,1.81959-1.15917.63487-.36648,1.27383-.69333,1.91024-.98982.62668.29132,1.26511.61409,1.91573.98982.64908.37472,1.25572.76346,1.82019,1.15958.06222.686.09682,1.40477.09682,2.15415s-.0346,1.46813-.09682,2.15415C15.16846,14.55027,14.56182,14.939,13.91274,15.31373Zm1.628.3351a17.87565,17.87565,0,0,1-.39136,1.82408,18.46424,18.46424,0,0,1-1.76012-.58257c.36293-.18713.72713-.38337,1.092-.594C14.8457,16.086,15.1977,15.86928,15.54078,15.64883Zm-4.92407,1.24372A18.41329,18.41329,0,0,1,8.851,17.474a17.86018,17.86018,0,0,1-.39176-1.82549c.34328.22058.69541.43734,1.06.64787C9.88355,16.50677,10.24989,16.70348,10.61671,16.89255ZM7.07428,13.25036A18.3863,18.3863,0,0,1,5.67548,12a18.38878,18.38878,0,0,1,1.3988-1.25043c-.02005.41033-.03252.82636-.03252,1.25043S7.05423,12.8401,7.07428,13.25036Zm1.385-4.89886a17.86727,17.86727,0,0,1,.391-1.82227,18.22228,18.22228,0,0,1,1.76937.57681c-.36775.18947-.735.38659-1.10031.59759C9.15468,7.91416,8.80255,8.13092,8.45927,8.3515Zm4.93057-1.242a18.48842,18.48842,0,0,1,1.75958-.58237,17.87565,17.87565,0,0,1,.39136,1.82408c-.34308-.22045-.69508-.43715-1.05948-.64754C14.11663,7.4931,13.75263,7.29652,13.38984,7.10946ZM16.92577,10.75A18.40125,18.40125,0,0,1,18.324,12a18.38809,18.38809,0,0,1-1.39826,1.25c.02-.41013.03251-.826.03251-1.25S16.94581,11.1601,16.92577,10.75ZM12,2.12854c.99773,0,2.05613,1.23433,2.80746,3.31044a20.80159,20.80159,0,0,0-2.8094,1.01141A20.51935,20.51935,0,0,0,9.19055,5.44481C9.94208,3.36508,11.00163,2.12854,12,2.12854ZM3.34774,7.00527c.35133-.60825,1.2519-.93437,2.52043-.93437a10.26212,10.26212,0,0,1,1.88362.20148A19.96778,19.96778,0,0,0,7.20147,9.2205a20.48874,20.48874,0,0,0-2.30166,1.95288C3.41412,9.44692,2.84341,7.87869,3.34774,7.00527Zm0,9.98946c-.50433-.87342.06638-2.44165,1.55207-4.16811A20.50145,20.50145,0,0,0,7.20147,14.7795a19.94422,19.94422,0,0,0,.5518,2.95356C5.50578,18.162,3.85468,17.87245,3.34774,16.99473ZM12,21.87146c-.99866,0-2.05847-1.23708-2.81007-3.31775a20.44828,20.44828,0,0,0,2.81155-1.00255,20.80209,20.80209,0,0,0,2.806,1.00979C14.05615,20.63706,12.99775,21.87146,12,21.87146Zm8.65175-4.87673c-.45914.79277-1.79257,1.10923-3.66667.86571-.2348-.03057-.48971-.09788-.73369-.14455a19.97619,19.97619,0,0,0,.5471-2.93619A20.50419,20.50419,0,0,0,19.0999,12.827C20.58532,14.55335,21.156,16.12138,20.65177,16.99473Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "12.00002", cy: "12", r: "2.197" }),
                React.createElement("path", { d: "M21.63441,6.43671c-.70909-1.22723-2.41155-1.73142-4.79628-1.42354-.30258.03942-.61354.09379-.92927.15769C15.00856,2.619,13.6066,1,12,1,10.39089,1,8.98713,2.62441,8.087,5.1834c-2.7384-.54268-4.90657-.15669-5.72186,1.25331C1.55256,7.84376,2.2947,9.90626,4.12193,12,2.2947,14.09374,1.55256,16.15624,2.3651,17.56329c.58143,1.00732,1.85,1.49542,3.52453,1.49542a11.47535,11.47535,0,0,0,2.197-.24305C8.98673,21.37518,10.39069,23,12,23c1.60658,0,3.00854-1.619,3.90884-4.17086.31573.0639.62669.11827.92927.15769a10.18235,10.18235,0,0,0,1.297.088c1.70461,0,2.92647-.52028,3.49932-1.51151.81254-1.407.07053-3.46955-1.75643-5.56329C21.70494,9.90626,22.447,7.84376,21.63441,6.43671ZM16.9851,6.13956a9.0809,9.0809,0,0,1,1.15965-.08046c1.26048,0,2.14979.32826,2.507.94617.50426.87335-.06645,2.44138-1.55187,4.16777a20.50554,20.50554,0,0,0-2.30139-1.95281,19.9752,19.9752,0,0,0-.5471-2.93612C16.49539,6.23744,16.7503,6.17013,16.9851,6.13956Zm-3.07236,9.17417c-.64647.37332-1.28408.70346-1.90695.9935-.63936-.29755-1.2812-.62534-1.919-.9935-.64888-.37459-1.25525-.76326-1.81959-1.15917-.06229-.6861-.09688-1.405-.09688-2.15456s.03459-1.46846.09688-2.15456c.56434-.39591,1.17071-.78458,1.81959-1.15917.63487-.36648,1.27383-.69333,1.91024-.98982.62668.29132,1.26511.61409,1.91573.98982.64908.37472,1.25572.76346,1.82019,1.15958.06222.686.09682,1.40477.09682,2.15415s-.0346,1.46813-.09682,2.15415C15.16846,14.55027,14.56182,14.939,13.91274,15.31373Zm1.628.3351a17.87565,17.87565,0,0,1-.39136,1.82408,18.46424,18.46424,0,0,1-1.76012-.58257c.36293-.18713.72713-.38337,1.092-.594C14.8457,16.086,15.1977,15.86928,15.54078,15.64883Zm-4.92407,1.24372A18.41329,18.41329,0,0,1,8.851,17.474a17.86018,17.86018,0,0,1-.39176-1.82549c.34328.22058.69541.43734,1.06.64787C9.88355,16.50677,10.24989,16.70348,10.61671,16.89255ZM7.07428,13.25036A18.3863,18.3863,0,0,1,5.67548,12a18.38878,18.38878,0,0,1,1.3988-1.25043c-.02005.41033-.03252.82636-.03252,1.25043S7.05423,12.8401,7.07428,13.25036Zm1.385-4.89886a17.86727,17.86727,0,0,1,.391-1.82227,18.22228,18.22228,0,0,1,1.76937.57681c-.36775.18947-.735.38659-1.10031.59759C9.15468,7.91416,8.80255,8.13092,8.45927,8.3515Zm4.93057-1.242a18.48842,18.48842,0,0,1,1.75958-.58237,17.87565,17.87565,0,0,1,.39136,1.82408c-.34308-.22045-.69508-.43715-1.05948-.64754C14.11663,7.4931,13.75263,7.29652,13.38984,7.10946ZM16.92577,10.75A18.40125,18.40125,0,0,1,18.324,12a18.38809,18.38809,0,0,1-1.39826,1.25c.02-.41013.03251-.826.03251-1.25S16.94581,11.1601,16.92577,10.75ZM12,2.12854c.99773,0,2.05613,1.23433,2.80746,3.31044a20.80159,20.80159,0,0,0-2.8094,1.01141A20.51935,20.51935,0,0,0,9.19055,5.44481C9.94208,3.36508,11.00163,2.12854,12,2.12854ZM3.34774,7.00527c.35133-.60825,1.2519-.93437,2.52043-.93437a10.26212,10.26212,0,0,1,1.88362.20148A19.96778,19.96778,0,0,0,7.20147,9.2205a20.48874,20.48874,0,0,0-2.30166,1.95288C3.41412,9.44692,2.84341,7.87869,3.34774,7.00527Zm0,9.98946c-.50433-.87342.06638-2.44165,1.55207-4.16811A20.50145,20.50145,0,0,0,7.20147,14.7795a19.94422,19.94422,0,0,0,.5518,2.95356C5.50578,18.162,3.85468,17.87245,3.34774,16.99473ZM12,21.87146c-.99866,0-2.05847-1.23708-2.81007-3.31775a20.44828,20.44828,0,0,0,2.81155-1.00255,20.80209,20.80209,0,0,0,2.806,1.00979C14.05615,20.63706,12.99775,21.87146,12,21.87146Zm8.65175-4.87673c-.45914.79277-1.79257,1.10923-3.66667.86571-.2348-.03057-.48971-.09788-.73369-.14455a19.97619,19.97619,0,0,0,.5471-2.93619A20.50419,20.50419,0,0,0,19.0999,12.827C20.58532,14.55335,21.156,16.12138,20.65177,16.99473Z" }))));
}
;
exports.default = EOS_PRIMITIVE;
