"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_POD_AUTOSCALER({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "5 11 3.5 11 3.5 8.5 0 12 3.5 15.5 3.5 13 5 13 5 11" }),
                React.createElement("polygon", { points: "24 12 20.5 8.5 20.5 11 19 11 19 13 20.5 13 20.5 15.5 24 12" }),
                React.createElement("path", { d: "M6,18.75213V18H18v1.00284A1.998,1.998,0,0,1,15.99958,21H8.00042A1.99626,1.99626,0,0,1,6,19.00284Z" }),
                React.createElement("path", { d: "M15,3.99178a.98562.98562,0,0,0-.29226-.70128A.99774.99774,0,0,0,14.00213,3H9.99787a.99819.99819,0,0,0-.91946.60575A.98347.98347,0,0,0,9,3.99178V5h6V3.99178Z" }),
                React.createElement("path", { d: "M18.74835,14.25,17.49664,11.5,16.245,8.75,14.99335,6H8.99994l-1.25,2.75L6.5,11.5,5.25,14.25,4,17H20Zm-4.89551-2.46149A2.00663,2.00663,0,1,1,14.01,11.01,2.0029,2.0029,0,0,1,13.85284,11.78851Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M15,4a1.00368,1.00368,0,0,0-1-1H10A1.00368,1.00368,0,0,0,9,4V5h6Z" }),
                React.createElement("path", { d: "M13.7,8l3.2,7H7.1l3.18-7ZM15,6H9L4,17H20Z" }),
                React.createElement("circle", { cx: "12", cy: "11", r: "1.5" }),
                React.createElement("path", { d: "M16,18v1H8V18H6v1.00281A1.99841,1.99841,0,0,0,8,21h8a1.99845,1.99845,0,0,0,2-1.99719V18Z" }),
                React.createElement("polygon", { points: "5 11 3.5 11 3.5 8.5 0 12 3.5 15.5 3.5 13 5 13 5 11" }),
                React.createElement("polygon", { points: "24 12 20.5 8.5 20.5 11 19 11 19 13 20.5 13 20.5 15.5 24 12" }))));
}
;
exports.default = EOS_POD_AUTOSCALER;
