"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_POD({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M6,19.00284A1.99877,1.99877,0,0,0,8.00042,21h7.99916A1.99881,1.99881,0,0,0,18,19.00284V18H6Z" }),
                React.createElement("path", { d: "M15,3.99178A.99485.99485,0,0,0,14.00213,3H9.99787A.99485.99485,0,0,0,9,3.99178V5h6Z" }),
                React.createElement("path", { d: "M14.99334,6H8.99994L4,17H20ZM12.01,13.01a2,2,0,1,1,2-2A2,2,0,0,1,12.01,13.01Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M15,4a1.00368,1.00368,0,0,0-1-1H10A1.00368,1.00368,0,0,0,9,4V5h6Z" }),
                React.createElement("path", { d: "M13.7,8l3.2,7H7.1l3.18-7ZM15,6H9L4,17H20Z" }),
                React.createElement("circle", { cx: "12", cy: "11", r: "1.5" }),
                React.createElement("path", { d: "M16,18v1H8V18H6v1.00281A1.99841,1.99841,0,0,0,8,21h8a1.99845,1.99845,0,0,0,2-1.99719V18Z" }))));
}
;
exports.default = EOS_POD;
