"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_PIN({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "18.27 9.81 15.45 9.81 9.77 4.13 10.48 3.42 9.06 2.01 1.99 9.08 3.41 10.49 4.12 9.78 9.79 15.46 9.78 15.46 9.78 18.29 11.2 19.71 14.74 16.16 19.51 20.93 20.92 19.52 16.15 14.75 19.68 11.22 18.27 9.81" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M9.67487,6.82922l3.54575,3.53739a5.00389,5.00389,0,0,0,2.8366,1.415l-4.2549,4.24486a4.9412,4.9412,0,0,0-1.4183-2.82991L6.83827,9.65913l2.8366-2.82991M10.384,3.29183l-7.0915,7.07478a1.00171,1.00171,0,0,0,1.4183,1.415h0L5.42,11.07409l3.54575,3.53739a2.99255,2.99255,0,0,1,0,4.24486l1.4183,1.415,4.23363-4.22364L19.5817,21H21V19.585L16.036,14.6327l4.27617-4.26609-1.4183-1.41495h0a3.00966,3.00966,0,0,1-4.2549,0L11.09317,5.41427l.70915-.70748h0a1.00171,1.00171,0,1,0-1.4183-1.415Z" }))));
}
;
exports.default = EOS_PIN;
