"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_PATCH_FIXES({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M14.47986,18.70978a3.99559,3.99559,0,0,1-5.163-5.27155L11.93561,16.057l2.12127-2.12134L11.43823,11.317a3.98842,3.98842,0,0,1,5.19989,5.30847l1.9328,1.9328A7.95941,7.95941,0,0,0,20,14,17.11481,17.11481,0,0,0,13.5.67a21.49375,21.49375,0,0,1,.74,4.8A3.47026,3.47026,0,0,1,10.83,9.2,3.63978,3.63978,0,0,1,7.2,5.47l.03-.36A13.76839,13.76839,0,0,0,4,14a7.99909,7.99909,0,0,0,12.43042,6.6604Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, id: "Layer_1", "data-name": "Layer 1", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M13.5.67a21.49375,21.49375,0,0,1,.74,4.8A3.47026,3.47026,0,0,1,10.83,9.2,3.63978,3.63978,0,0,1,7.2,5.47l.03-.36A13.76839,13.76839,0,0,0,4,14a7.94546,7.94546,0,0,0,9.07648,7.91925c.0877-.01184.17431-.02515.261-.03986a7.95393,7.95393,0,0,0,.99958-.22833l.02093-.00537a7.92391,7.92391,0,0,0,.9787-.38171c.06757-.03113.13367-.06348.2002-.09644.17358-.08587.33606-.18915.50305-.28552l.00915.00915c.03675-.02166.06763-.0512.104-.07342.08386-.05035.17407-.09107.25555-.145l.02173-.01233.00232-.00226a7.944,7.944,0,0,0,.70172-.53283l.02625-.0235a8.05273,8.05273,0,0,0,.92364-.91608l.00708-.007-.0003-.0003c.168-.19776.32739-.403.476-.61646l.00378-.00372.00379-.00635a7.98908,7.98908,0,0,0,.5625-.9519c.02484-.04908.04767-.09882.07153-.14844a7.93347,7.93347,0,0,0,.405-1.00012l.01031-.02814a7.95179,7.95179,0,0,0,.25177-1.06262c.014-.08136.02582-.16272.03736-.24488A8.02445,8.02445,0,0,0,20,14,17.11481,17.11481,0,0,0,13.5.67Zm1.86224,15.76294a3.27764,3.27764,0,0,0-4.44336-4.11871c.67237.67639,1.47449,1.4834,2.14679,2.15979-.469.4718-1.0288,1.035-1.49774,1.50683-.688-.67639-1.50885-1.48339-2.19671-2.15979a3.29346,3.29346,0,0,0,4.09387,4.47028c.33764.33954.7193.72351,1.11194,1.11859l-.078.03736a5.73451,5.73451,0,0,1-.74414.291,6.00336,6.00336,0,0,1-.771.17188l-.17676.02734A5.94205,5.94205,0,0,1,12,20a6.00657,6.00657,0,0,1-6-6,11.875,11.875,0,0,1,.85791-4.43311,5.5615,5.5615,0,0,0,3.97217,1.63331A5.34243,5.34243,0,0,0,16.11133,6.771,14.78734,14.78734,0,0,1,18,14a5.975,5.975,0,0,1-.06641.833l-.02832.1875a6.24715,6.24715,0,0,1-.16992.74121l-.02734.081a5.79184,5.79184,0,0,1-.29492.72852l-.0625.12793a5.68028,5.68028,0,0,1-.40821.69531l-.0166.02442c-.07989.115-.17975.21032-.26654.31872C16.20062,17.27618,15.75391,16.82684,15.36224,16.43292Z" }))));
}
;
exports.default = EOS_PATCH_FIXES;
