"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_MULTISTATE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "4", cy: "4", r: "3" }),
                React.createElement("path", { d: "M4,15a3,3,0,1,1,3-3A3,3,0,0,1,4,15Zm0-5a2,2,0,1,0,2,2A2,2,0,0,0,4,10Z" }),
                React.createElement("path", { d: "M12,23a3,3,0,1,1,3-3A3,3,0,0,1,12,23Zm0-5a2,2,0,1,0,2,2A2,2,0,0,0,12,18Z" }),
                React.createElement("path", { d: "M20,7a3,3,0,1,1,3-3A3,3,0,0,1,20,7Zm0-5a2,2,0,1,0,2,2A2,2,0,0,0,20,2Z" }),
                React.createElement("circle", { cx: "4", cy: "20", r: "3" }),
                React.createElement("circle", { cx: "12", cy: "4", r: "3" }),
                React.createElement("circle", { cx: "12", cy: "12", r: "3" }),
                React.createElement("circle", { cx: "20", cy: "12", r: "3" }),
                React.createElement("circle", { cx: "20", cy: "20", r: "3" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "4", cy: "4", r: "3" }),
                React.createElement("path", { d: "M4,15a3,3,0,1,1,3-3A3,3,0,0,1,4,15Zm0-5a2,2,0,1,0,2,2A2,2,0,0,0,4,10Z" }),
                React.createElement("path", { d: "M12,23a3,3,0,1,1,3-3A3,3,0,0,1,12,23Zm0-5a2,2,0,1,0,2,2A2,2,0,0,0,12,18Z" }),
                React.createElement("path", { d: "M20,7a3,3,0,1,1,3-3A3,3,0,0,1,20,7Zm0-5a2,2,0,1,0,2,2A2,2,0,0,0,20,2Z" }),
                React.createElement("circle", { cx: "4", cy: "20", r: "3" }),
                React.createElement("circle", { cx: "12", cy: "4", r: "3" }),
                React.createElement("circle", { cx: "12", cy: "12", r: "3" }),
                React.createElement("circle", { cx: "20", cy: "12", r: "3" }),
                React.createElement("circle", { cx: "20", cy: "20", r: "3" }))));
}
;
exports.default = EOS_MULTISTATE;
