"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_MOVE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "22.017 12.008 18.019 8.01 18.017 11.003 13.016 11.003 13.016 6.013 16.009 6.015 12.007 2.013 8.009 6.011 11.003 6.012 11.003 11.003 6.003 11.003 6.002 8.01 2.004 12.008 6.006 16.01 6.004 13.017 11.003 13.017 11.003 18.01 8.009 18.011 12.007 22.01 16.009 18.008 13.016 18.009 13.016 13.017 18.016 13.017 18.015 16.01 22.017 12.008" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "22.017 12.008 18.019 8.01 18.017 11.003 13.016 11.003 13.016 6.013 16.009 6.015 12.007 2.013 8.009 6.011 11.003 6.012 11.003 11.003 6.003 11.003 6.002 8.01 2.004 12.008 6.006 16.01 6.004 13.017 11.003 13.017 11.003 18.01 8.009 18.011 12.007 22.01 16.009 18.008 13.016 18.009 13.016 13.017 18.016 13.017 18.015 16.01 22.017 12.008" }))));
}
;
exports.default = EOS_MOVE;
