"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_MOBILE_FRIENDLY({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19 1H9c-1.1 0-2 .9-2 2v3h2V4h10v16H9v-2H7v3c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zM7.01 13.47l-2.55-2.55-1.27 1.27L7 16l7.19-7.19-1.27-1.27z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19 1H9c-1.1 0-2 .9-2 2v3h2V4h10v16H9v-2H7v3c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zM7.01 13.47l-2.55-2.55-1.27 1.27L7 16l7.19-7.19-1.27-1.27-5.91 5.93z" }))));
}
;
exports.default = EOS_MOBILE_FRIENDLY;
