"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_LOCKED_ENV({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M17,8H16V6A5,5,0,0,0,6,6V8H5a2.00587,2.00587,0,0,0-2,2V20a2.00591,2.00591,0,0,0,2,2H17a2.00591,2.00591,0,0,0,2-2V10A2.00587,2.00587,0,0,0,17,8ZM7.27966,14.5896v.75214H5.97473v.87738H7.45026V17H5V13H7.45l.00025.78088H5.97473v.80872ZM7.9,6a3.1,3.1,0,1,1,6.2,0V8H7.9ZM12.1676,17h-.97381L9.56433,14.533V17H8.5896V13h.97473l1.62946,2.479V13h.97381Zm3.43354,0H14.39886L13,13h1l1,3,1-3h1Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "7.829 14.59 7.829 15.342 6.524 15.342 6.524 16.219 8 16.219 8 17 5.55 17 5.55 13 8 13 8 13.781 6.524 13.781 6.524 14.59 7.829 14.59" }),
                React.createElement("path", { d: "M17,8H16V6A5,5,0,0,0,6,6V8H5a2.00587,2.00587,0,0,0-2,2V20a2.00591,2.00591,0,0,0,2,2H17a2.00591,2.00591,0,0,0,2-2V10A2.00587,2.00587,0,0,0,17,8ZM7.9,6a3.1,3.1,0,1,1,6.2,0V8H7.9ZM17,20H5V10H17Z" }),
                React.createElement("polygon", { points: "12.168 17 11.194 17 9.564 14.533 9.564 17 8.59 17 8.59 13 9.564 13 11.194 15.479 11.194 13 12.168 13 12.168 17" }),
                React.createElement("polygon", { points: "15.101 17 13.899 17 12.5 13 13.5 13 14.5 16 15.5 13 16.5 13 15.101 17" }))));
}
;
exports.default = EOS_LOCKED_ENV;
