"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_KUBELET({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M2.80267,15H0l1.25-2.75L2.5,9.5,3.75,6.75,4.99994,4h2.803L6.55286,6.75,5.3028,9.5,4.05273,12.25ZM8,1.99219c0-.08737.00448-.17357.01294-.25859s.02088-.16886.03678-.25154.03526-.16418.05758-.24452S8.15489,1.078,8.18262,1H5.99786a.99812.99812,0,0,0-.91945.60572A.98355.98355,0,0,0,5,1.99176V3H8V1.99219ZM5,17.00293l-.75-.0007-.75-.0007-.75-.00071L2,17.00012v.00269A1.998,1.998,0,0,0,4.00043,19H5.55548a4.28607,4.28607,0,0,1-.23192-.45819,4.03033,4.03033,0,0,1-.17482-.48759,3.8479,3.8479,0,0,1-.11032-.514A3.775,3.775,0,0,1,5,17.00293ZM16,1.99176a.98562.98562,0,0,0-.29225-.70128A.99784.99784,0,0,0,15.00214,1H10.99786a.99812.99812,0,0,0-.91945.60572A.98355.98355,0,0,0,10,1.99176V3h6V1.99176ZM15.30231,16H7v1.00281A1.998,1.998,0,0,0,9.00043,19h3.2832l.75467-.75.75467-.75.75467-.75Zm.21728-1H5l1.25-2.75L7.5,9.5,8.75,6.75,9.99994,4h5.99341l.72526,1.59348L17.44388,7.187l.72526,1.59348.72527,1.59347q-.25422.09933-.49839.22276-.24372.1234-.4747.27075a5.25185,5.25185,0,0,0-.44565.31846,5.05229,5.05229,0,0,0-.41122.36589A5.25371,5.25371,0,0,0,15.51959,15ZM15.01,9.01a1.99373,1.99373,0,1,0-.15718.77848A1.99371,1.99371,0,0,0,15.01,9.01Zm-.00089,13.84593,1.14268-1.1358,1.14269-1.1358,1.14269-1.1358,1.14268-1.1358a3.19787,3.19787,0,0,0,1.80821.14978,3.24675,3.24675,0,0,0,.87585-.31828,3.36092,3.36092,0,0,0,.78167-.58038,3.212,3.212,0,0,0,.60352-.83,3.26,3.26,0,0,0,.30686-.94234,3.33383,3.33383,0,0,0,.01491-.97978,3.28554,3.28554,0,0,0-.27233-.94234l-.54.5367-.54.53669-.53995.5367-.54.5367-.37671-.37444-.37671-.37444-.37671-.37444-.37671-.37444.54-.54918.53995-.54918.54-.54918.54-.54917a3.0768,3.0768,0,0,0-.94805-.29176,3.21424,3.21424,0,0,0-.98572.01717,3.30991,3.30991,0,0,0-.94805.31671A3.377,3.377,0,0,0,17.891,13.7477a3.20218,3.20218,0,0,0-.32021.87057,3.14271,3.14271,0,0,0,.15069,1.79731l-1.14269,1.1358-1.14268,1.1358L14.29337,19.823l-1.14269,1.1358a.51871.51871,0,0,0-.113.16538.4687.4687,0,0,0,0,.3682.51871.51871,0,0,0,.113.16538l.28881.28707.28881.28707.28882.28707.28881.28707a.52624.52624,0,0,0,.17344.14119.49083.49083,0,0,0,.197.05227.43073.43073,0,0,0,.18757-.032A.35136.35136,0,0,0,15.00912,22.85594Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M23.97089,14.81171a3.28581,3.28581,0,0,0-.27234-.94233c-.6764.67235-1.48345,1.47447-2.15979,2.14679-.47184-.469-1.035-1.02881-1.50684-1.49774.67639-.688,1.48336-1.50883,2.15979-2.19671a3.29344,3.29344,0,0,0-4.47027,4.09387c-1.01789,1.01212-2.41031,2.39549-3.42805,3.40735-.76985.87227-2.037,1.36119-.56491,2.40886,1.13125,1.50464,1.4688.306,2.42339-.51173,1.017-1.01121,2.41087-2.396,3.428-3.40733A3.28985,3.28985,0,0,0,23.97089,14.81171Z" }),
                React.createElement("path", { d: "M16,2a1.00368,1.00368,0,0,0-1-1H11a1.00368,1.00368,0,0,0-1,1V3h6Z" }),
                React.createElement("circle", { cx: "13", cy: "9", r: "1.5" }),
                React.createElement("path", { d: "M9,1H7A1.00366,1.00366,0,0,0,6,2V3H8V2C8,1.17078,8.44885,1,9,1Z" }),
                React.createElement("polygon", { points: "6 4 1 15 3 15 8 4 6 4" }),
                React.createElement("path", { d: "M5,17.00281V16H3v1.00281A1.99841,1.99841,0,0,0,5,19H7A1.77267,1.77267,0,0,1,5,17.00281Z" }),
                React.createElement("path", { d: "M16.0592,13H8.1l3.18-7H14.7l2.49927,5.4671a5.58264,5.58264,0,0,1,1.69427-1.092L15.99,4H10L5,15H15.49561A5.01813,5.01813,0,0,1,16.0592,13Z" }),
                React.createElement("path", { d: "M23.97089,14.81171a3.28581,3.28581,0,0,0-.27234-.94233c-.6764.67235-1.48345,1.47447-2.15979,2.14679-.47184-.469-1.035-1.02881-1.50684-1.49774.67639-.688,1.48336-1.50883,2.15979-2.19671a3.29344,3.29344,0,0,0-4.47027,4.09387c-1.01789,1.01212-2.41031,2.39549-3.42805,3.40735-.76985.87227-2.037,1.36119-.56491,2.40886,1.13125,1.50464,1.4688.306,2.42339-.51173,1.017-1.01121,2.41087-2.396,3.428-3.40733A3.28985,3.28985,0,0,0,23.97089,14.81171Z" }),
                React.createElement("path", { d: "M14.29681,17H9V16H7v1.00281A1.99841,1.99841,0,0,0,9,19h3.26367C12.3172,18.95081,14.29681,17,14.29681,17Z" }))));
}
;
exports.default = EOS_KUBELET;
