"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_INGRESS({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M14,24H10V20h4v4Zm2-13.98247H13v7.99631H11V10.01753H8L9,9.0166l1-1.00092,1-1.00092,1-1.00092,1,1.00092,1,1.00092L15,9.0166ZM1,15.99935V3.00065a1.9829,1.9829,0,0,1,.15781-.77682,2.01986,2.01986,0,0,1,1.06563-1.066A1.98115,1.98115,0,0,1,3,1H21a1.98115,1.98115,0,0,1,.77656.15786,2.01986,2.01986,0,0,1,1.06563,1.066A1.9829,1.9829,0,0,1,23,3.00065v12.9987a1.98294,1.98294,0,0,1-.15781.77682,2.01986,2.01986,0,0,1-1.06563,1.066A1.98115,1.98115,0,0,1,21,18H15V16.00935h6V3.0096H3V16.00935H9V18H3a1.98115,1.98115,0,0,1-.77656-.15786,2.01986,2.01986,0,0,1-1.06563-1.066A1.98294,1.98294,0,0,1,1,15.99935Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M14,24H10V20h4v4Zm2-13.98247H13v7.99631H11V10.01753H8L9,9.0166l1-1.00092,1-1.00092,1-1.00092,1,1.00092,1,1.00092L15,9.0166ZM1,15.99935V3.00065a1.9829,1.9829,0,0,1,.15781-.77682,2.01986,2.01986,0,0,1,1.06563-1.066A1.98115,1.98115,0,0,1,3,1H21a1.98115,1.98115,0,0,1,.77656.15786,2.01986,2.01986,0,0,1,1.06563,1.066A1.9829,1.9829,0,0,1,23,3.00065v12.9987a1.98294,1.98294,0,0,1-.15781.77682,2.01986,2.01986,0,0,1-1.06563,1.066A1.98115,1.98115,0,0,1,21,18H15V16.00935h6V3.0096H3V16.00935H9V18H3a1.98115,1.98115,0,0,1-.77656-.15786,2.01986,2.01986,0,0,1-1.06563-1.066A1.98294,1.98294,0,0,1,1,15.99935Z" }))));
}
;
exports.default = EOS_INGRESS;
