"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_HOURGLASS_ANIMATED({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
        React.createElement("g", null,
            React.createElement("path", { d: "M7 3H17V7.2L12 12L7 7.2V3Z" },
                React.createElement("animate", { id: "first", attributeName: "opacity", from: "1", to: "0", dur: "2s", begin: "0;second.end", fill: "freeze" })),
            React.createElement("path", { d: "M17 21H7V16.8L12 12L17 16.8V21Z" },
                React.createElement("animate", { attributeName: "opacity", from: "0", to: "1", dur: "2s", begin: "0;second.end", fill: "freeze" })),
            React.createElement("path", { d: "M6 2V8H6.01L6 8.01L10 12L6 16L6.01 16.01H6V22H18V16.01H17.99L18 16L14 12L18 8.01L17.99 8H18V2H6ZM16 16.5V20H8V16.5L12 12.5L16 16.5ZM12 11.5L8 7.5V4H16V7.5L12 11.5Z" }),
            React.createElement("animateTransform", { id: "second", attributeName: "transform", attributeType: "XML", type: "rotate", from: "0 12 12", to: "180 12 12", dur: "0.5s", begin: "first.end" }))));
}
;
exports.default = EOS_HOURGLASS_ANIMATED;
