"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_GENOMIC({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M15.36843,16a21.01159,21.01159,0,0,0-2.75187-3.99213S10.12143,9.15338,10.00325,9h2.44729c-.16273.23248-.33436.45081-.51222.67743l1.32536,1.52924A23.84756,23.84756,0,0,0,15.45361,8a11.2306,11.2306,0,0,0,1.53445-5c.02343-.50739.00665-1.03766-.00189-1.57489A.95819.95819,0,0,0,15.993.5a.99989.99989,0,0,0-.9971,1.02069C15.01919,2.0141,14.99,2.49707,14.99063,3l-6.99207.00177c.00049-.04657.00183-1.49695.00183-1.49695A.98856.98856,0,0,0,7.00024.5a.94762.94762,0,0,0-.995.955L6.00357,2.8139a11.61466,11.61466,0,0,0,2.85352,7.918s3.32444,3.938,3.55806,4.26807h-2.3493c.04466-.058.30159-.366.56774-.68378L9.299,12.77631l-.44193.50824A10.42143,10.42143,0,0,0,7.16358,16a11.6667,11.6667,0,0,0-1.16,5.1861L6.00522,22.545a.94762.94762,0,0,0,.995.955.98856.98856,0,0,0,1.00015-1.00482s-.00134-1.45038-.00183-1.497L14.99063,21c-.00061.50293.02856.9859.00531,1.47931A.99989.99989,0,0,0,15.993,23.5a.95819.95819,0,0,0,.99313-.92511c.00854-.53723.02532-1.0675.00189-1.57489A11.36138,11.36138,0,0,0,15.36843,16ZM14.45267,5A12.71121,12.71121,0,0,1,13.671,7H8.81182a9.91746,9.91746,0,0,1-.61393-2Zm-3.16818,8.54065.0011-.00134.03069.038ZM8.19789,19a9.91746,9.91746,0,0,1,.61393-2H13.671a12.71121,12.71121,0,0,1,.78172,2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M15.36843,16a21.01159,21.01159,0,0,0-2.75187-3.99213S10.12143,9.15338,10.00325,9h2.44729c-.16273.23248-.33436.45081-.51222.67743l1.32536,1.52924A23.84756,23.84756,0,0,0,15.45361,8a11.2306,11.2306,0,0,0,1.53445-5c.02343-.50739.00665-1.03766-.00189-1.57489A.95819.95819,0,0,0,15.993.5a.99989.99989,0,0,0-.9971,1.02069C15.01919,2.0141,14.99,2.49707,14.99063,3l-6.99207.00177c.00049-.04657.00183-1.49695.00183-1.49695A.98856.98856,0,0,0,7.00024.5a.94762.94762,0,0,0-.995.955L6.00357,2.8139a11.61466,11.61466,0,0,0,2.85352,7.918s3.32444,3.938,3.55806,4.26807h-2.3493c.04466-.058.30159-.366.56774-.68378L9.299,12.77631l-.44193.50824A10.42143,10.42143,0,0,0,7.16358,16a11.6667,11.6667,0,0,0-1.16,5.1861L6.00522,22.545a.94762.94762,0,0,0,.995.955.98856.98856,0,0,0,1.00015-1.00482s-.00134-1.45038-.00183-1.497L14.99063,21c-.00061.50293.02856.9859.00531,1.47931A.99989.99989,0,0,0,15.993,23.5a.95819.95819,0,0,0,.99313-.92511c.00854-.53723.02532-1.0675.00189-1.57489A11.36138,11.36138,0,0,0,15.36843,16ZM14.45267,5A12.71121,12.71121,0,0,1,13.671,7H8.81182a9.91746,9.91746,0,0,1-.61393-2Zm-3.16818,8.54065.0011-.00134.03069.038ZM8.19789,19a9.91746,9.91746,0,0,1,.61393-2H13.671a12.71121,12.71121,0,0,1,.78172,2Z" }))));
}
;
exports.default = EOS_GENOMIC;
