"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_FORK({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M22,5a3,3,0,1,0-4,2.81628V11H6V7.81628a3,3,0,1,0-2,0V11a2,2,0,0,0,2,2h5v4.18372a3,3,0,1,0,2,0V13h5a2,2,0,0,0,2-2V7.81628A2.99121,2.99121,0,0,0,22,5Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,2a2.99289,2.99289,0,0,0-1,5.81628V11H6V7.81628a3,3,0,1,0-2,0V11a2,2,0,0,0,2,2h5v4.18372a3,3,0,1,0,2,0V13h5a2,2,0,0,0,2-2V7.81628A2.99289,2.99289,0,0,0,19,2ZM5,6A1,1,0,1,1,6,5,1,1,0,0,1,5,6Zm7,15a1,1,0,1,1,1-1A1,1,0,0,1,12,21ZM19,6a1,1,0,1,1,1-1A1,1,0,0,1,19,6Z" }))));
}
;
exports.default = EOS_FORK;
