"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_ENDPOINTS_CONNECTED({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "21.02 13.01 21.02 11.01 17.01 11.01 17.01 6.01 18.01 6.01 18.01 2.01 14.01 2.01 14.01 6.01 15.01 6.01 15.01 11.01 3.01 11.01 3.01 13.01 7 13.01 7 18 6 18 6 22 9.99 22 9.99 18 8.99 18 8.99 13.01 21.02 13.01" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "21.02 13.01 21.02 11.01 17.01 11.01 17.01 6.01 18.01 6.01 18.01 2.01 14.01 2.01 14.01 6.01 15.01 6.01 15.01 11.01 3.01 11.01 3.01 13.01 7 13.01 7 18 6 18 6 22 9.99 22 9.99 18 8.99 18 8.99 13.01 21.02 13.01" }))));
}
;
exports.default = EOS_ENDPOINTS_CONNECTED;
