"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_DRONE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M24,8V7H17V8h3V9H19v2H15.69934L14.19855,8.40051H9.85486L8.35406,11H5V9H4V8H7V7H0V8H3V9H2v5H5V13H8.16669l.21594.374A8.00236,8.00236,0,0,0,4,20.5a.5.5,0,0,0,1,0,7.00142,7.00142,0,0,1,3.88336-6.25873l.9715,1.68274h4.34369l.9599-1.6626A7.002,7.002,0,0,1,19,20.5a.5.5,0,0,0,1,0,8.00291,8.00291,0,0,0-4.34082-7.10583L15.88678,13H19v1h3V9H21V8Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M24,8V7H17V8h3V9H19v2H15.69934L14.19855,8.40051H9.85486L8.35406,11H5V9H4V8H7V7H0V8H3V9H2v5H5V13H8.16669l.21594.374A8.00236,8.00236,0,0,0,4,20.5a.5.5,0,0,0,1,0,7.00142,7.00142,0,0,1,3.88336-6.25873l.9715,1.68274h4.34369l.9599-1.6626A7.002,7.002,0,0,1,19,20.5a.5.5,0,0,0,1,0,8.00291,8.00291,0,0,0-4.34082-7.10583L15.88678,13H19v1h3V9H21V8Z" }))));
}
;
exports.default = EOS_DRONE;
