"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_DIFF_MODIFIED({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19.2,3H4.8A1.8,1.8,0,0,0,3,4.8V19.2A1.8,1.8,0,0,0,4.8,21H19.2A1.8,1.8,0,0,0,21,19.2V4.8A1.8,1.8,0,0,0,19.2,3ZM12,16a4,4,0,1,1,4-4A4,4,0,0,1,12,16Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19.2,3H4.8A1.8,1.8,0,0,0,3,4.8V19.2A1.8,1.8,0,0,0,4.8,21H19.2A1.8,1.8,0,0,0,21,19.2V4.8A1.8,1.8,0,0,0,19.2,3ZM19,19H5V5H19Z" }),
                React.createElement("circle", { cx: "12", cy: "12", r: "4" }))));
}
;
exports.default = EOS_DIFF_MODIFIED;
