"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_DAEMON_SET({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M3.00488,21.99472h0a2,2,0,0,1-2-2h0V6.005h2V19.99472H18.99512v2H3.00488ZM16.09808,9.99365a.89633.89633,0,1,0-.35057-.07065A.89819.89819,0,0,0,16.09808,9.99365Zm-5.16369,1.81726a3.32918,3.32918,0,0,0,1.18823,1.50977,3.26862,3.26862,0,0,0,3.75281,0,3.3287,3.3287,0,0,0,1.18817-1.50977H10.93439ZM11.9,9.99365a.89633.89633,0,1,0-.35057-.07065A.89829.89829,0,0,0,11.9,9.99365Zm11.1-5.93V15.93634A2.06369,2.06369,0,0,1,20.93634,18H7.06366A2.06369,2.06369,0,0,1,5,15.93634V4.06366A2.06369,2.06369,0,0,1,7.06366,2H20.93634A2.06369,2.06369,0,0,1,23,4.06366ZM18.93878,8.41943q.03855-.0617.0745-.12554t.06906-.12989q.03309-.06606.06318-.13434t.05687-.13891A3.03152,3.03152,0,0,0,19.1405,5.587a2.99967,2.99967,0,0,0-.65825-.94493,2.949,2.949,0,0,0-1.0055-.63717l-.00454-.00143-.00462-.00107-.0046-.00106L17.45844,4a2.97755,2.97755,0,0,1,.29724.61556,3.028,3.028,0,0,1-.02954,2.06986l-.00051.00115-.00059.00105-.00058.00108-.00052.00112a5.46064,5.46064,0,0,0-.78755-.62492,5.36838,5.36838,0,0,0-5.87474,0,5.4611,5.4611,0,0,0-.78754.62492l-.0005-.00112-.0006-.00108-.00059-.00105-.00051-.00115a2.894,2.894,0,0,1-.16936-.69924,2.96749,2.96749,0,0,1,.004-.69925,3.09121,3.09121,0,0,1,.161-.67137A3.145,3.145,0,0,1,10.56946,4l-.00458.00138-.00458.00106-.00463.00107-.00458.00143A2.99654,2.99654,0,0,0,9.541,4.64211a3.049,3.049,0,0,0-.93651,2.07023,2.97388,2.97388,0,0,0,.19121,1.17841q.02675.07064.05683.13891t.06323.13434q.03309.06606.069.12989t.07451.12554a5.45152,5.45152,0,0,0-.19556.5121,5.39988,5.39988,0,1,0,10.27063,0A5.45152,5.45152,0,0,0,18.93878,8.41943Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M3,20V6H1V20a2.00107,2.00107,0,0,0,2,2H19V20l-7.99946-.00129Z" }),
                React.createElement("path", { d: "M17.29253,8.94628q.05136-.08224.0957-.17026a1.94137,1.94137,0,0,0,.08-.18217A2.021,2.021,0,0,0,17.427,7.058,1.97679,1.97679,0,0,0,16.31785,6.0033l-.00612-.00166L16.30562,6a2.01317,2.01317,0,0,1,.17846,1.7903l-.00072.00147-.00072.00146a3.61649,3.61649,0,0,0-1.12248-.73108,3.59,3.59,0,0,0-2.72163,0,3.61652,3.61652,0,0,0-1.12246.73108l-.00073-.00146-.00073-.00147a1.94883,1.94883,0,0,1-.11028-.93234A2.0838,2.0838,0,0,1,11.713,6l-.00613.00164-.00612.00166a2.0176,2.0176,0,0,0-1.1703,2.59055,1.944,1.944,0,0,0,.08.18217q.04415.08806.09571.17026a3.59979,3.59979,0,1,0,6.58637,0Zm-1.89382-.15115a.59921.59921,0,1,1-.42431.17559A.59753.59753,0,0,1,15.39871,8.79513Zm-2.79873,0a.59921.59921,0,1,1-.42431.17559A.59753.59753,0,0,1,12.6,8.79513ZM13.99934,12.608a2.17244,2.17244,0,0,1-1.25093-.39422,2.21911,2.21911,0,0,1-.79213-1.00652h4.08613a2.21911,2.21911,0,0,1-.79213,1.00652A2.17245,2.17245,0,0,1,13.99934,12.608Z" }),
                React.createElement("path", { d: "M22.39557,2.60443A1.91081,1.91081,0,0,0,21,2H7a1.91093,1.91093,0,0,0-1.39557.60443A1.911,1.911,0,0,0,5,4V16a1.91115,1.91115,0,0,0,.60443,1.39557A1.91115,1.91115,0,0,0,7,18H21a2.06727,2.06727,0,0,0,2-2V4A1.91081,1.91081,0,0,0,22.39557,2.60443ZM21,16H7V4H21Z" }))));
}
;
exports.default = EOS_DAEMON_SET;
