"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_DAEMON({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20.23132,9.3657q.12838-.20559.23926-.42565a4.85691,4.85691,0,0,0,.20006-.45543,5.05268,5.05268,0,0,0-.10316-3.83957,4.942,4.942,0,0,0-2.77286-2.63681l-.01529-.00414L17.76405,2a5.03291,5.03291,0,0,1,.44615,4.47575l-.0018.00366-.0018.00367a9.04129,9.04129,0,0,0-2.8062-1.82771,8.975,8.975,0,0,0-6.80407,0A9.0413,9.0413,0,0,0,5.79018,6.48308l-.00183-.00367-.00183-.00366A4.87211,4.87211,0,0,1,5.51083,4.1449,5.20933,5.20933,0,0,1,6.28244,2l-.01531.0041-.01531.00414A5.044,5.044,0,0,0,3.32609,8.48462a4.85424,4.85424,0,0,0,.2.45543q.11034.22016.23926.42565a8.99949,8.99949,0,1,0,16.46592,0Zm-4.73455-.37788a1.498,1.498,0,1,1-1.06077.439A1.49388,1.49388,0,0,1,15.49677,8.98782Zm-6.99682,0a1.498,1.498,0,1,1-1.06078.439A1.49384,1.49384,0,0,1,8.5,8.98782ZM11.99836,18.52A5.43128,5.43128,0,0,1,8.871,17.53448a5.548,5.548,0,0,1-1.98033-2.51632H17.106a5.548,5.548,0,0,1-1.98033,2.51632A5.43128,5.43128,0,0,1,11.99836,18.52Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M15.5,9a1.49154,1.49154,0,0,0-1.064.42676A1.52184,1.52184,0,0,0,14,10.5a1.468,1.468,0,0,0,.436,1.05042A1.51109,1.51109,0,0,0,15.5,12a1.49566,1.49566,0,0,0,1.05756-.44958A1.47361,1.47361,0,0,0,17,10.5a1.52737,1.52737,0,0,0-.44244-1.07324A1.47606,1.47606,0,0,0,15.5,9Z" }),
                React.createElement("path", { d: "M8.5,9a1.499,1.499,0,1,0,1.06064.43873A1.49574,1.49574,0,0,0,8.5,9Z" }),
                React.createElement("path", { d: "M18,2a16.28231,16.28231,0,0,1,.51074,2.1449,5.04081,5.04081,0,0,1-.084,1.56024A8.98677,8.98677,0,0,0,5.57385,5.70453,4.92174,4.92174,0,0,1,5.5108,4.1449,4.90812,4.90812,0,0,1,6,2,9.82127,9.82127,0,0,0,3.4541,4.645a4.99571,4.99571,0,0,0-.128,3.8396,4.85141,4.85141,0,0,0,.2.45538l.01148.02039a9,9,0,1,0,16.92352-.00354L20.47058,8.94a4.85176,4.85176,0,0,0,.20007-.45538A5.05271,5.05271,0,0,0,20.5675,4.645,9.59889,9.59889,0,0,0,18,2ZM12,19a7,7,0,1,1,7-7,7.00794,7.00794,0,0,1-7,7Z" }),
                React.createElement("path", { d: "M7,14a5.49328,5.49328,0,0,0,5,3,5.49328,5.49328,0,0,0,5-3Z" }))));
}
;
exports.default = EOS_DAEMON;
