"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_COUNTING({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "2", y: "2", width: "2", height: "20" }),
                React.createElement("rect", { x: "11", y: "-5", width: "2", height: "20", transform: "translate(17 -7) rotate(90)" }),
                React.createElement("rect", { x: "20", y: "2", width: "2", height: "20" }),
                React.createElement("circle", { cx: "8", cy: "5", r: "2" }),
                React.createElement("rect", { x: "11", y: "1", width: "2", height: "20", transform: "translate(23 -1) rotate(90)" }),
                React.createElement("circle", { cx: "10", cy: "11", r: "2" }),
                React.createElement("circle", { cx: "16", cy: "11", r: "2" }),
                React.createElement("rect", { x: "11", y: "7", width: "2", height: "20", transform: "translate(29 5) rotate(90)" }),
                React.createElement("rect", { x: "11", y: "10", width: "2", height: "24", transform: "translate(34 10) rotate(90)" }),
                React.createElement("circle", { cx: "8", cy: "17", r: "2" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "2", y: "2", width: "2", height: "20" }),
                React.createElement("rect", { x: "11", y: "-5", width: "2", height: "20", transform: "translate(17 -7) rotate(90)" }),
                React.createElement("rect", { x: "20", y: "2", width: "2", height: "20" }),
                React.createElement("circle", { cx: "8", cy: "5", r: "2" }),
                React.createElement("rect", { x: "11", y: "1", width: "2", height: "20", transform: "translate(23 -1) rotate(90)" }),
                React.createElement("circle", { cx: "10", cy: "11", r: "2" }),
                React.createElement("circle", { cx: "16", cy: "11", r: "2" }),
                React.createElement("rect", { x: "11", y: "7", width: "2", height: "20", transform: "translate(29 5) rotate(90)" }),
                React.createElement("rect", { x: "11", y: "10", width: "2", height: "24", transform: "translate(34 10) rotate(90)" }),
                React.createElement("circle", { cx: "8", cy: "17", r: "2" }))));
}
;
exports.default = EOS_COUNTING;
