"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_CONTENT_LIFECYCLE_MANAGEMENT({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "6", y: "7", width: "8", height: "2" }),
                React.createElement("rect", { x: "6", y: "11", width: "12", height: "2" }),
                React.createElement("rect", { x: "6", y: "15", width: "2.99", height: "2" }),
                React.createElement("path", { d: "M14,3,11,0V2H4A2,2,0,0,0,2,4V20a2,2,0,0,0,2,2H8V20H4V4h7V6Z" }),
                React.createElement("path", { d: "M10,21l3,3V22h7a2,2,0,0,0,2-2V4a2,2,0,0,0-2-2H16V4h4V20H13V18Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "6", y: "7", width: "8", height: "2" }),
                React.createElement("rect", { x: "6", y: "11", width: "12", height: "2" }),
                React.createElement("rect", { x: "6", y: "15", width: "2.99", height: "2" }),
                React.createElement("path", { d: "M14,3,11,0V2H4A2,2,0,0,0,2,4V20a2,2,0,0,0,2,2H8V20H4V4h7V6Z" }),
                React.createElement("path", { d: "M10,21l3,3V22h7a2,2,0,0,0,2-2V4a2,2,0,0,0-2-2H16V4h4V20H13V18Z" }))));
}
;
exports.default = EOS_CONTENT_LIFECYCLE_MANAGEMENT;
