"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_CONSTRAINT({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21,15V13.5a2.5,2.5,0,0,0-5,0V15a1.07539,1.07539,0,0,0-1,1v4a1.07539,1.07539,0,0,0,1,1h5a1.07539,1.07539,0,0,0,1-1V16A1.07539,1.07539,0,0,0,21,15Zm-1,0H17V13.5a1.5,1.5,0,0,1,3,0ZM22,5H2V3H22Zm0,4H2V7H22Zm-9,4H2V11H13Zm0,4H2V15H13Zm0,4H2V19H13Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21,15V13.5a2.5,2.5,0,0,0-5,0V15a1.07539,1.07539,0,0,0-1,1v4a1.07539,1.07539,0,0,0,1,1h5a1.07539,1.07539,0,0,0,1-1V16A1.07539,1.07539,0,0,0,21,15Zm-1,0H17V13.5a1.5,1.5,0,0,1,3,0ZM22,5H2V3H22Zm0,4H2V7H22Zm-9,4H2V11H13Zm0,4H2V15H13Zm0,4H2V19H13Z" }))));
}
;
exports.default = EOS_CONSTRAINT;
