"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_CONFIGURATION_FILE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M10.50732,14.14178a1.35,1.35,0,1,0,1.35,1.35A1.34823,1.34823,0,0,0,10.50732,14.14178Z" }),
                React.createElement("path", { d: "M14,2.01H6a1.99728,1.99728,0,0,0-1.99,2L4,20.01a1.99735,1.99735,0,0,0,1.99,2H18a2.00591,2.00591,0,0,0,2-2v-12Zm.86328,14.95783-.9,1.55694a.23583.23583,0,0,1-.279.099l-1.12494-.45a3.32752,3.32752,0,0,1-.756.441l-.171,1.188a.23109.23109,0,0,1-.225.189h-1.8a.224.224,0,0,1-.225-.189l-.171-1.188a3.07863,3.07863,0,0,1-.765-.441l-1.116.45a.22824.22824,0,0,1-.279-.099l-.9-1.55694a.23374.23374,0,0,1,.054-.288l.954-.747a3.61782,3.61782,0,0,1,0-.882l-.954-.74694a.22282.22282,0,0,1-.054-.288l.9-1.557a.23572.23572,0,0,1,.279-.099l1.116.45a3.59269,3.59269,0,0,1,.765-.441l.171-1.18805a.23111.23111,0,0,1,.225-.189h1.8a.21488.21488,0,0,1,.216.189l.171,1.18805a3.07838,3.07838,0,0,1,.765.441l1.116-.45a.22828.22828,0,0,1,.279.099l.9,1.557a.23383.23383,0,0,1-.054.288l-.954.74694a2.36811,2.36811,0,0,1,.03595.441,3.49515,3.49515,0,0,1-.03595.441l.963.747A.23367.23367,0,0,1,14.86328,16.96783ZM13,9.01V3.51l5.5,5.5Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M13.69119,15.77819l-.6308-.48933A2.2891,2.2891,0,0,0,13.084,15a1.5482,1.5482,0,0,0-.02357-.28886l.6249-.48933a.15308.15308,0,0,0,.03537-.18865l-.58953-1.01988a.14952.14952,0,0,0-.18275-.06484l-.731.29477a2.01585,2.01585,0,0,0-.50112-.2889l-.112-.77815a.1408.1408,0,0,0-.14151-.12382H10.28368a.15136.15136,0,0,0-.14738.12382l-.112.77815a2.355,2.355,0,0,0-.50109.2889l-.731-.29477a.15442.15442,0,0,0-.18276.06484L8.0199,14.03316a.14594.14594,0,0,0,.03537.18865l.6249.48933a2.36591,2.36591,0,0,0,0,.57772l-.6249.48933a.15306.15306,0,0,0-.03537.18865l.58953,1.01988a.14953.14953,0,0,0,.18276.06484l.731-.29477a2.01611,2.01611,0,0,0,.50109.28887l.112.77818a.14678.14678,0,0,0,.14738.12382h1.17907a.15138.15138,0,0,0,.14738-.12382l.112-.77818a2.17821,2.17821,0,0,0,.49522-.28887l.73692.29477a.15441.15441,0,0,0,.18275-.06484l.58953-1.01988A.1531.1531,0,0,0,13.69119,15.77819Zm-2.818.10611A.8843.8843,0,1,1,11.75751,15,.88312.88312,0,0,1,10.87321,15.8843Z" }),
                React.createElement("path", { d: "M14,2H6A2.00587,2.00587,0,0,0,4,4V20a2.00591,2.00591,0,0,0,2,2H18a2.00591,2.00591,0,0,0,2-2V8Zm4,18H6V4h7V9h5Z" }))));
}
;
exports.default = EOS_CONFIGURATION_FILE;
