"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_COMPASS_ANIMATED({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
        React.createElement("path", { d: "M12 10.9c-.61 0-1.1.49-1.1 1.1s.49 1.1 1.1 1.1c.61 0 1.1-.49 1.1-1.1s-.49-1.1-1.1-1.1zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm2.19 12.19L6 18l3.81-8.19L18 6l-3.81 8.19z" },
            React.createElement("animateTransform", { id: "first", attributeName: "transform", attributeType: "XML", type: "rotate", from: "-90 12 12", to: "0 12 12", dur: "1s", begin: "0;third.end" }),
            React.createElement("animateTransform", { id: "second", attributeName: "transform", attributeType: "XML", type: "rotate", from: "0 12 12", to: "-90 12 12", dur: "1s", begin: "first.end" }),
            React.createElement("animateTransform", { id: "third", attributeName: "transform", attributeType: "XML", type: "rotate", from: "-90 12 12", to: "270 12 12", dur: "1s", begin: "second.end" }))));
}
;
exports.default = EOS_COMPASS_ANIMATED;
