"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_COLLOCATION({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,2H4A2,2,0,0,0,2,4V20a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V4A2,2,0,0,0,20,2Zm0,18H4V4H20Z" }),
                React.createElement("path", { d: "M7.51,18A2.5,2.5,0,0,0,10,16h4.1a2.5,2.5,0,1,0,2.45-3h-.05L14.08,8.9a2.5,2.5,0,1,0-4.14,0L7.56,13h0a2.5,2.5,0,0,0,0,5Zm3.17-8.39a2.46,2.46,0,0,0,2.66,0l2.1,3.64A2.49,2.49,0,0,0,14.06,15H10a2.49,2.49,0,0,0-1.38-1.75Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,2H4A2,2,0,0,0,2,4V20a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V4A2,2,0,0,0,20,2Zm0,18H4V4H20Z" }),
                React.createElement("path", { d: "M7.51,18A2.5,2.5,0,0,0,10,16h4.1a2.5,2.5,0,1,0,2.45-3h-.05L14.08,8.9a2.5,2.5,0,1,0-4.14,0L7.56,13h0a2.5,2.5,0,0,0,0,5Zm3.17-8.39a2.46,2.46,0,0,0,2.66,0l2.1,3.64A2.49,2.49,0,0,0,14.06,15H10a2.49,2.49,0,0,0-1.38-1.75Z" }))));
}
;
exports.default = EOS_COLLOCATION;
