"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_CLUSTER_ROLE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,4H14.82A3,3,0,0,0,9.18,4H5A2,2,0,0,0,3,6V20a2,2,0,0,0,2,2H19a2,2,0,0,0,2-2V6A2,2,0,0,0,19,4ZM12,4a1,1,0,1,1-1,1A1,1,0,0,1,12,4Zm7,15H5V15H19Zm0-6H5V9H19Z" }),
                React.createElement("circle", { cx: "17", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "14", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "14", cy: "17", r: "1" }),
                React.createElement("circle", { cx: "17", cy: "17", r: "1" }),
                React.createElement("rect", { x: "6", y: "10", width: "5", height: "2" }),
                React.createElement("rect", { x: "6", y: "16", width: "5", height: "2" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,4H14.82A3,3,0,0,0,9.18,4H5A2,2,0,0,0,3,6V20a2,2,0,0,0,2,2H19a2,2,0,0,0,2-2V6A2,2,0,0,0,19,4ZM12,4a1,1,0,1,1-1,1A1,1,0,0,1,12,4Zm7,15H5V15H19Zm0-6H5V9H19Z" }),
                React.createElement("circle", { cx: "17", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "14", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "14", cy: "17", r: "1" }),
                React.createElement("circle", { cx: "17", cy: "17", r: "1" }),
                React.createElement("rect", { x: "6", y: "10", width: "5", height: "2" }),
                React.createElement("rect", { x: "6", y: "16", width: "5", height: "2" }))));
}
;
exports.default = EOS_CLUSTER_ROLE;
