"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_CLUSTER_MANAGEMENT({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M1,1V11H23V1ZM13,7H4V5h9Zm3,0a1,1,0,1,1,1-1A1,1,0,0,1,16,7Zm3,0a1,1,0,1,1,1-1A1,1,0,0,1,19,7Z" }),
                React.createElement("path", { d: "M22.69,18.37l1.14-1-1-1.73-1.45.49a3.64664,3.64664,0,0,0-1.08-.63L20,14H18l-.3,1.49a3.64645,3.64645,0,0,0-1.08.63l-1.45-.49-1,1.73,1.14,1a3.33714,3.33714,0,0,0,0,1.26l-1.14,1,1,1.73,1.45-.49a3.64535,3.64535,0,0,0,1.08.63L18,24h2l.3-1.49a3.64645,3.64645,0,0,0,1.08-.63l1.45.49,1-1.73-1.14-1A3.38931,3.38931,0,0,0,22.69,18.37ZM19,21a2,2,0,1,1,2-2A2.00591,2.00591,0,0,1,19,21Z" }),
                React.createElement("path", { d: "M12,19H4V17h8.2937A7.00761,7.00761,0,0,1,15.408,13H1V23H13.26A6.96194,6.96194,0,0,1,12,19Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M22.69,18.37l1.14-1-1-1.73-1.45.49a3.64664,3.64664,0,0,0-1.08-.63L20,14H18l-.3,1.49a3.64645,3.64645,0,0,0-1.08.63l-1.45-.49-1,1.73,1.14,1a3.33714,3.33714,0,0,0,0,1.26l-1.14,1,1,1.73,1.45-.49a3.64535,3.64535,0,0,0,1.08.63L18,24h2l.3-1.49a3.64645,3.64645,0,0,0,1.08-.63l1.45.49,1-1.73-1.14-1A3.38931,3.38931,0,0,0,22.69,18.37ZM19,21a2,2,0,1,1,2-2A2.00591,2.00591,0,0,1,19,21Z" }),
                React.createElement("path", { d: "M23,11H1V1H23ZM3,9H21V3H3ZM13,5H4V7h9Zm3,0a1,1,0,1,0,1,1A1,1,0,0,0,16,5Zm3,0a1,1,0,1,0,1,1A1,1,0,0,0,19,5Z" }),
                React.createElement("path", { d: "M12.2937,21H3V15H13.26a7.02625,7.02625,0,0,1,2.148-2H1V23H13.26A6.96217,6.96217,0,0,1,12.2937,21Z" }),
                React.createElement("path", { d: "M4,19h8a6.99364,6.99364,0,0,1,.2937-2H4Z" }))));
}
;
exports.default = EOS_CLUSTER_MANAGEMENT;
