"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_CLOUD_CONTROLLER_MANAGER({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M9,10l8,0v2.00007L9,12Zm15,0H21V8H19v6h2V12h3Z" }),
                React.createElement("path", { d: "M9,20h8v2H9Zm15,0H21V18H19v6h2V22h3Z" }),
                React.createElement("path", { d: "M24,17H16V15h8ZM9,17h3v2h2V13H12v2H9Z" }),
                React.createElement("path", { d: "M19,5.99983,7,6V16s-7,.1698-7-6A6.0712,6.0712,0,0,1,1.23518,5.99983,5.98944,5.98944,0,0,1,5.694,4.00989a4.86019,4.86019,0,0,1,.57242-.99l.27116-.36c.07031-.08.1506-.17.231-.26a3.597,3.597,0,0,1,.2611-.29A6.89655,6.89655,0,0,1,12,0c.16065,0,.36206.01.51272.02a7.0122,7.0122,0,0,1,3.75581,1.39,8.54643,8.54643,0,0,1,.91382.81A7.0434,7.0434,0,0,1,19,5.99983Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M9,10l8,0v2.00007L9,12Zm15,0H21V8H19v6h2V12h3Z" }),
                React.createElement("path", { d: "M9,20h8v2H9Zm15,0H21V18H19v6h2V22h3Z" }),
                React.createElement("path", { d: "M24,17H16V15h8ZM9,17h3v2h2V13H12v2H9Z" }),
                React.createElement("path", { d: "M19,5.99983,7,6V16s-7,.1698-7-6A6.0712,6.0712,0,0,1,1.23518,5.99983,5.98944,5.98944,0,0,1,5.694,4.00989a4.86019,4.86019,0,0,1,.57242-.99l.27116-.36c.07031-.08.1506-.17.231-.26a3.597,3.597,0,0,1,.2611-.29A6.89655,6.89655,0,0,1,12,0c.16065,0,.36206.01.51272.02a7.0122,7.0122,0,0,1,3.75581,1.39,8.54643,8.54643,0,0,1,.91382.81A7.0434,7.0434,0,0,1,19,5.99983Z" }))));
}
;
exports.default = EOS_CLOUD_CONTROLLER_MANAGER;
