"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_BLOCKCHAIN({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M12,8,9,9.75v3.5L12,15l3-1.75V9.75Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L12,9.15472Zm-3.5271.88269,1.48461.866v1.75043l-1.48461-.866Zm2.47435,2.65234V11.80829l1.54617-.90192v1.76624Z" }),
                React.createElement("path", { d: "M3,0,0,1.75v3.5L3,7,6,5.25V1.75ZM4.51684,2.03949l-1.53034.8927L1.46963,2.04742,3,1.15472Zm-3.5271.88269,1.48461.866V5.53864l-1.48461-.866ZM3.46409,5.57452V3.80829l1.54617-.90192V4.67261Z" }),
                React.createElement("path", { d: "M3,17,0,18.75v3.5L3,24l3-1.75v-3.5Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L3,18.15472Zm-3.5271.88269,1.48461.866v1.75043l-1.48461-.866Zm2.47435,2.65234V20.80829l1.54617-.90192v1.76624Z" }),
                React.createElement("path", { d: "M21,0,18,1.75v3.5L21,7l3-1.75V1.75Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L21,1.15472Zm-3.5271.88269,1.48461.866V5.53864l-1.48461-.866Zm2.47435,2.65234V3.80829l1.54617-.90192V4.67261Z" }),
                React.createElement("path", { d: "M21,17l-3,1.75v3.5L21,24l3-1.75v-3.5Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L21,18.15472Zm-3.5271.88269,1.48461.866v1.75043l-1.48461-.866Zm2.47435,2.65234V20.80829l1.54617-.90192v1.76624Z" }),
                React.createElement("rect", { x: "9", y: "3", width: "6", height: "1" }),
                React.createElement("rect", { x: "9", y: "20", width: "6", height: "1" }),
                React.createElement("rect", { y: "11.5", width: "6", height: "1", transform: "translate(15 9) rotate(90)" }),
                React.createElement("rect", { x: "5.08579", y: "6.91421", width: "3", height: "1", transform: "translate(6 17.31371) rotate(-135)" }),
                React.createElement("rect", { x: "15.91421", y: "7.08579", width: "3", height: "1", transform: "translate(-0.26346 14.53553) rotate(-45)" }),
                React.createElement("rect", { x: "5.21447", y: "15.08579", width: "3", height: "1", transform: "translate(22.48313 21.85876) rotate(135)" }),
                React.createElement("rect", { x: "16.08579", y: "15.04289", width: "3", height: "1", transform: "translate(16.14124 -7.88262) rotate(45)" }),
                React.createElement("rect", { x: "18", y: "11.5", width: "6", height: "1", transform: "translate(33 -9) rotate(90)" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M12,8,9,9.75v3.5L12,15l3-1.75V9.75Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L12,9.15472Zm-3.5271.88269,1.48461.866v1.75043l-1.48461-.866Zm2.47435,2.65234V11.80829l1.54617-.90192v1.76624Z" }),
                React.createElement("path", { d: "M3,0,0,1.75v3.5L3,7,6,5.25V1.75ZM4.51684,2.03949l-1.53034.8927L1.46963,2.04742,3,1.15472Zm-3.5271.88269,1.48461.866V5.53864l-1.48461-.866ZM3.46409,5.57452V3.80829l1.54617-.90192V4.67261Z" }),
                React.createElement("path", { d: "M3,17,0,18.75v3.5L3,24l3-1.75v-3.5Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L3,18.15472Zm-3.5271.88269,1.48461.866v1.75043l-1.48461-.866Zm2.47435,2.65234V20.80829l1.54617-.90192v1.76624Z" }),
                React.createElement("path", { d: "M21,0,18,1.75v3.5L21,7l3-1.75V1.75Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L21,1.15472Zm-3.5271.88269,1.48461.866V5.53864l-1.48461-.866Zm2.47435,2.65234V3.80829l1.54617-.90192V4.67261Z" }),
                React.createElement("path", { d: "M21,17l-3,1.75v3.5L21,24l3-1.75v-3.5Zm1.51687,2.03949-1.53034.8927-1.51687-.88477L21,18.15472Zm-3.5271.88269,1.48461.866v1.75043l-1.48461-.866Zm2.47435,2.65234V20.80829l1.54617-.90192v1.76624Z" }),
                React.createElement("rect", { x: "9", y: "3", width: "6", height: "1" }),
                React.createElement("rect", { x: "9", y: "20", width: "6", height: "1" }),
                React.createElement("rect", { y: "11.5", width: "6", height: "1", transform: "translate(15 9) rotate(90)" }),
                React.createElement("rect", { x: "5.08579", y: "6.91421", width: "3", height: "1", transform: "translate(6 17.31371) rotate(-135)" }),
                React.createElement("rect", { x: "15.91421", y: "7.08579", width: "3", height: "1", transform: "translate(-0.26346 14.53553) rotate(-45)" }),
                React.createElement("rect", { x: "5.21447", y: "15.08579", width: "3", height: "1", transform: "translate(22.48313 21.85876) rotate(135)" }),
                React.createElement("rect", { x: "16.08579", y: "15.04289", width: "3", height: "1", transform: "translate(16.14124 -7.88262) rotate(45)" }),
                React.createElement("rect", { x: "18", y: "11.5", width: "6", height: "1", transform: "translate(33 -9) rotate(90)" }))));
}
;
exports.default = EOS_BLOCKCHAIN;
