"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_AUGMENTED_REALITY({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M11.5,3.311,19,7.6531v8.6938L11.5,20.689,4,16.3469V7.6531L11.5,3.311M11.5,1,2,6.5v11L11.5,23,21,17.5V6.5L11.5,1Z" }),
                React.createElement("path", { d: "M11.5,5a.5.5,0,1,0,.5.5.5.5,0,0,0-.5-.5Z" }),
                React.createElement("path", { d: "M11.5,8.5A.5.5,0,1,0,12,9a.5.5,0,0,0-.5-.5Z" }),
                React.createElement("path", { d: "M11.5,12a.5.5,0,1,0,.5.5.5.5,0,0,0-.5-.5Z" }),
                React.createElement("path", { d: "M7.99952,12.99988a.5.5,0,1,0,.422.23109.49766.49766,0,0,0-.422-.23109Z" }),
                React.createElement("path", { d: "M5.4994,15.00013a.5.5,0,1,0,.422.23109.49766.49766,0,0,0-.422-.23109Z" }),
                React.createElement("path", { d: "M15.00041,12.99994a.50009.50009,0,1,0,.2685.07857.49959.49959,0,0,0-.2685-.07857Z" }),
                React.createElement("path", { d: "M17.5351,15.00013a.50009.50009,0,1,0,.2685.07857.4996.4996,0,0,0-.2685-.07857Z" }),
                React.createElement("polygon", { points: "3.382 6.225 2.382 7.957 9.409 12.014 10.409 10.282 3.382 6.225 3.382 6.225" }),
                React.createElement("polygon", { points: "12.5 17.016 10.5 17.016 10.5 22.157 12.5 22.157 12.5 17.016 12.5 17.016" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M11.5,3.311,19,7.6531v8.6938L11.5,20.689,4,16.3469V7.6531L11.5,3.311M11.5,1,2,6.5v11L11.5,23,21,17.5V6.5L11.5,1Z" }),
                React.createElement("path", { d: "M11.5,5a.5.5,0,1,0,.5.5.5.5,0,0,0-.5-.5Z" }),
                React.createElement("path", { d: "M11.5,8.5A.5.5,0,1,0,12,9a.5.5,0,0,0-.5-.5Z" }),
                React.createElement("path", { d: "M11.5,12a.5.5,0,1,0,.5.5.5.5,0,0,0-.5-.5Z" }),
                React.createElement("path", { d: "M7.99952,12.99988a.5.5,0,1,0,.422.23109.49766.49766,0,0,0-.422-.23109Z" }),
                React.createElement("path", { d: "M5.4994,15.00013a.5.5,0,1,0,.422.23109.49766.49766,0,0,0-.422-.23109Z" }),
                React.createElement("path", { d: "M15.00041,12.99994a.50009.50009,0,1,0,.2685.07857.49959.49959,0,0,0-.2685-.07857Z" }),
                React.createElement("path", { d: "M17.5351,15.00013a.50009.50009,0,1,0,.2685.07857.4996.4996,0,0,0-.2685-.07857Z" }),
                React.createElement("polygon", { points: "3.382 6.225 2.382 7.957 9.409 12.014 10.409 10.282 3.382 6.225 3.382 6.225" }),
                React.createElement("polygon", { points: "12.5 17.016 10.5 17.016 10.5 22.157 12.5 22.157 12.5 17.016 12.5 17.016" }))));
}
;
exports.default = EOS_AUGMENTED_REALITY;
