"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_APP_REGISTRATION({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { height: "4", width: "4", x: "10", y: "4" }),
                React.createElement("rect", { height: "4", width: "4", x: "4", y: "16" }),
                React.createElement("rect", { height: "4", width: "4", x: "4", y: "10" }),
                React.createElement("rect", { height: "4", width: "4", x: "4", y: "4" }),
                React.createElement("polygon", { points: "14,12.42 14,10 10,10 10,14 12.42,14" }),
                React.createElement("path", { d: "M20.88,11.29l-1.17-1.17c-0.16-0.16-0.42-0.16-0.58,0L18.25,11L20,12.75l0.88-0.88C21.04,11.71,21.04,11.45,20.88,11.29z" }),
                React.createElement("polygon", { points: "11,18.25 11,20 12.75,20 19.42,13.33 17.67,11.58" }),
                React.createElement("rect", { height: "4", width: "4", x: "16", y: "4" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { height: "4", width: "4", x: "10", y: "4" }),
                React.createElement("rect", { height: "4", width: "4", x: "4", y: "16" }),
                React.createElement("rect", { height: "4", width: "4", x: "4", y: "10" }),
                React.createElement("rect", { height: "4", width: "4", x: "4", y: "4" }),
                React.createElement("rect", { height: "4", width: "4", x: "16", y: "4" }),
                React.createElement("polygon", { points: "11,17.86 11,20 13.1,20 19.08,14.03 16.96,11.91" }),
                React.createElement("polygon", { points: "14,12.03 14,10 10,10 10,14 12.03,14" }),
                React.createElement("path", { d: "M20.85,11.56l-1.41-1.41c-0.2-0.2-0.51-0.2-0.71,0l-1.06,1.06l2.12,2.12l1.06-1.06C21.05,12.07,21.05,11.76,20.85,11.56z" }))));
}
;
exports.default = EOS_APP_REGISTRATION;
