"use strict";
// GENERATED BY ./scripts/iconScript.ts
Object.defineProperty(exports, "__esModule", { value: true });
const React = require("react");
const helper_1 = require("../helper");
const flipFunction_1 = require("../flipFunction");
function EOS_ABSTRACT({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(helper_1.valuesMap).includes(sizeString)) {
        size = helper_1.valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction_1.flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M16,3H8A2,2,0,0,0,6.29,4l-4,7a2,2,0,0,0,0,2l4,7A2,2,0,0,0,8,21h8a2,2,0,0,0,1.74-1l4-7a2,2,0,0,0,0-2l-4-7A2,2,0,0,0,16,3Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21.73188,11,17.72905,4A1.96655,1.96655,0,0,0,16.0099,3H8.00424A2.0381,2.0381,0,0,0,6.271,4L2.26812,11a1.99891,1.99891,0,0,0,0,2L6.271,20a2.03786,2.03786,0,0,0,1.73329,1H16.0099a1.96634,1.96634,0,0,0,1.71915-1l4.00283-7A1.99891,1.99891,0,0,0,21.73188,11ZM16,19H8L4,12,8,5h8l4,7Z" }))));
}
;
exports.default = EOS_ABSTRACT;
