// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_VOLUME_BINDING({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M6,18.99988A5.99988,5.99988,0,0,1,12,13h4V3a2.00073,2.00073,0,0,0-2-2H4A2.00073,2.00073,0,0,0,2,3V19.001A1.99984,1.99984,0,0,0,4,21H6.34875A5.97625,5.97625,0,0,1,6,18.99988ZM14,2a1,1,0,1,1-1,1A1,1,0,0,1,14,2ZM9,3a5,5,0,1,1-2,9.57788V10H4.42212A4.99113,4.99113,0,0,1,9,3ZM4,2A1,1,0,1,1,3,3,1,1,0,0,1,4,2ZM4,20a1,1,0,1,1,1-1A1,1,0,0,1,4,20Z" }),
                React.createElement("circle", { cx: "9", cy: "8.00004", r: "2" }),
                React.createElement("rect", { x: "13", y: "18", width: "4", height: "2" }),
                React.createElement("path", { d: "M18,15H16v2h2a2,2,0,0,1,0,4H16v2h2a4,4,0,0,0,0-8Z" }),
                React.createElement("path", { d: "M14,21H12a2,2,0,0,1,0-4h2V15H12a4,4,0,0,0,0,8h2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "14", y: "18", width: "4", height: "2" }),
                React.createElement("path", { d: "M19,15H17v2h2a2,2,0,0,1,0,4H17v2h2a4,4,0,0,0,0-8Z" }),
                React.createElement("path", { d: "M13,17h2V15H13a4,4,0,0,0,0,8h2V21H13a2,2,0,0,1,0-4Z" }),
                React.createElement("path", { d: "M6,4A1,1,0,1,1,5,3,1,1,0,0,1,6,4Z" }),
                React.createElement("path", { d: "M16,4a1,1,0,1,1-1-1A1,1,0,0,1,16,4Z" }),
                React.createElement("path", { d: "M6,20a1,1,0,1,1-1-1A1,1,0,0,1,6,20Z" }),
                React.createElement("path", { d: "M9.69061,24H3a2,2,0,0,1-2-2V2A2,2,0,0,1,3,0H17a2,2,0,0,1,2,2V13H17V2H3V22H7.81183A6.03966,6.03966,0,0,0,9.69061,24Z" }),
                React.createElement("path", { d: "M14.57788,13A4.99759,4.99759,0,1,0,6,14H9v.54059A5.9687,5.9687,0,0,1,13,13ZM10,13a2,2,0,1,1,2-2A2,2,0,0,1,10,13Z" }))));
}
;
export default EOS_VOLUME_BINDING;
