// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_VOLUME({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M17,2H7A2.00073,2.00073,0,0,0,5,4V20a2.00073,2.00073,0,0,0,2,2H17a2.00073,2.00073,0,0,0,2-2V4A2.00073,2.00073,0,0,0,17,2ZM7,3A1,1,0,1,1,6,4,1,1,0,0,1,7,3ZM7,21a1,1,0,1,1,1-1A1,1,0,0,1,7,21Zm5-7a4.97274,4.97274,0,0,1-2-.42212V11H7.42212A4.99716,4.99716,0,1,1,12,14Zm5,7a1,1,0,1,1,1-1A1,1,0,0,1,17,21ZM17,5a1,1,0,1,1,1-1A1,1,0,0,1,17,5Z" }),
                React.createElement("circle", { cx: "12", cy: "9", r: "2" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,22H5V2H19ZM19,0H5A2,2,0,0,0,3,2V22a2,2,0,0,0,2,2H19a2,2,0,0,0,2-2V2a2,2,0,0,0-2-2Z" }),
                React.createElement("path", { d: "M8,4A1,1,0,1,1,7,3,1,1,0,0,1,8,4Z" }),
                React.createElement("path", { d: "M18,4a1,1,0,1,1-1-1A1,1,0,0,1,18,4Z" }),
                React.createElement("path", { d: "M8,20a1,1,0,1,1-1-1A1,1,0,0,1,8,20Z" }),
                React.createElement("path", { d: "M18,20a1,1,0,1,1-1-1A1,1,0,0,1,18,20Z" }),
                React.createElement("path", { d: "M12,6a5,5,0,0,0-5,5,4.93633,4.93633,0,0,0,1,3h3v1.89923A5.00112,5.00112,0,0,0,17,11C17,6,12,6,12,6Zm0,7a2,2,0,1,1,2-2,2,2,0,0,1-2,2Z" }))));
}
;
export default EOS_VOLUME;
