// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_TEST_TUBE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, id: "Layer_1", "data-name": "Layer 1", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "13", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "11.5", cy: "7.5", r: "0.5" }),
                React.createElement("circle", { cx: "12.5", cy: "5.5", r: "0.5" }),
                React.createElement("path", { d: "M5,0V2H7V19a5,5,0,0,0,10,0V2h2V0ZM15,2V15H12a1,1,0,0,0-2,0H9V2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, id: "Layer_1", "data-name": "Layer 1", xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "13", cy: "11", r: "1" }),
                React.createElement("circle", { cx: "11.5", cy: "7.5", r: "0.5" }),
                React.createElement("circle", { cx: "12.5", cy: "5.5", r: "0.5" }),
                React.createElement("path", { d: "M5,0V2H7V19a5,5,0,0,0,10,0V2h2V0ZM15,2V15H12a1,1,0,0,0-2,0H9V2Z" }))));
}
;
export default EOS_TEST_TUBE;
