// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_TEMPLATES({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,2H5A2.005,2.005,0,0,0,3,4V20a2.005,2.005,0,0,0,2,2H19a2.005,2.005,0,0,0,2-2V4A2.005,2.005,0,0,0,19,2Zm0,11.15167V18.848L14,16ZM12,14.846,7,12H17ZM5,4H19V6H5ZM5,8h8v2H5Zm5,8L5,18.84833V13.14386Zm2,1.14978L17,20H7Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,0H4A2,2,0,0,0,2,2V22a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V2A2,2,0,0,0,20,0Zm0,22H4V2H20Z" }),
                React.createElement("rect", { x: "6", y: "4", width: "12", height: "2" }),
                React.createElement("rect", { x: "6", y: "8", width: "7", height: "2" }),
                React.createElement("polygon", { points: "8 20 16 20 12 17 8 20" }),
                React.createElement("polygon", { points: "19 19 19 13 14 16 19 19" }),
                React.createElement("polygon", { points: "6 13 6 19 10 16 6 13" }),
                React.createElement("polygon", { points: "16 12 8 12 12 15 16 12" }))));
}
;
export default EOS_TEMPLATES;
