// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_SYSTEM_IMAGE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M17,3H6A2,2,0,0,0,4,5V20a2,2,0,0,0,2,2H17a2,2,0,0,0,1.41-.58A2,2,0,0,0,19,20V2ZM6,6h8V8H6Zm4,14H8V18h2Zm0-6h4v2H10Zm7,6H11V18h6Zm0-4H15V14h2Zm0-4H12V10h5Zm0-4H15V6h2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M13,6V8H7V6Zm-2,4v2h6V10ZM8,14v2h5V14Zm3,4v2h6V18ZM7,18v2H9V18Zm8-4v2h2V14Zm0-8V8h2V6Zm4,16H5V4H19ZM19,2H5A2,2,0,0,0,3,4V22a2,2,0,0,0,2,2H19a2,2,0,0,0,2-2V0Z" }))));
}
;
export default EOS_SYSTEM_IMAGE;
