// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_STRAIGHTEN({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 10H3V8h2v4h2V8h2v4h2V8h2v4h2V8h2v4h2V8h2v8z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm0 10H3V8h2v4h2V8h2v4h2V8h2v4h2V8h2v4h2V8h2v8z" }))));
}
;
export default EOS_STRAIGHTEN;
