// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_SMART_BUTTON({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M22,9v6c0,1.1-0.9,2-2,2h-1v-2h1V9H4v6h6v2H4c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h16C21.1,7,22,7.9,22,9z M14.5,19l1.1-2.4\tl2.4-1.1l-2.4-1.1L14.5,12l-1.1,2.4L11,15.5l2.4,1.1L14.5,19z M17,14l0.6-1.4L19,12l-1.4-0.6L17,10l-0.6,1.4L15,12l1.4,0.6L17,14z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M22,9v6c0,1.1-0.9,2-2,2h-1v-2h1V9H4v6h6v2H4c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h16C21.1,7,22,7.9,22,9z M14.5,19l1.1-2.4\tl2.4-1.1l-2.4-1.1L14.5,12l-1.1,2.4L11,15.5l2.4,1.1L14.5,19z M17,14l0.6-1.4L19,12l-1.4-0.6L17,10l-0.6,1.4L15,12l1.4,0.6L17,14z" }))));
}
;
export default EOS_SMART_BUTTON;
